/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;

public class SwingUtil {
    public static final Color COLOR_OPAQUE = SwingUtil.createAlphaedColor(Color.WHITE, 0);

    private SwingUtil() {
    }

    public static final Color createAlphaedColor(Color c, int alpha) {
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public static Component getDeepestComponentAt(Component parent, int x, int y) {
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] components = ((Container)parent).getComponents();
            int i = 0;
            while (i < components.length) {
                Component comp = components[i];
                if (comp != null && comp.isVisible()) {
                    Point loc = comp.getLocation();
                    if ((comp = comp instanceof Container ? SwingUtil.getDeepestComponentAt(comp, x - loc.x, y - loc.y) : comp.getComponentAt(x - loc.x, y - loc.y)) != null && comp.isVisible() && !(comp instanceof LayerVisualComponent)) {
                        return comp;
                    }
                }
                ++i;
            }
        }
        return parent;
    }
}

