/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    public static final int CENTER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int FILL = 4;
    private int align;
    private int vGap;
    private int hGap;

    public VerticalFlowLayout() {
        this(2);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalFlowLayout(int align, int vGap, int hGap) {
        this.align = align;
        this.vGap = vGap;
        this.hGap = hGap;
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int width = 0;
            int height = 0;
            int componentCount = parent.getComponentCount();
            int i = 0;
            while (i < componentCount) {
                Component component = parent.getComponent(i);
                if (component.isVisible()) {
                    Dimension d = component.getPreferredSize();
                    width = Math.max(width, d.width);
                    height = height + this.vGap + d.height;
                }
                ++i;
            }
            Insets insets = parent.getInsets();
            return new Dimension(insets.left + insets.right + width + this.hGap * 2, insets.top + insets.bottom + height + this.vGap * 2);
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            int x = insets.left + this.hGap;
            int y = insets.top + this.vGap;
            int componentCount = parent.getComponentCount();
            int i = 0;
            while (i < componentCount) {
                Component component = parent.getComponent(i);
                if (component.isVisible()) {
                    Dimension d = component.getPreferredSize();
                    int w = d.width;
                    int h = d.height;
                    int parentWidth = parent.getWidth();
                    switch (this.align) {
                        case 1: {
                            x = parentWidth / 2 - d.width / 2;
                            break;
                        }
                        case 3: {
                            x = parentWidth - d.width - insets.right - this.hGap;
                            break;
                        }
                        case 4: {
                            w = parentWidth - insets.left - insets.right - this.hGap * 2;
                        }
                    }
                    component.setBounds(x, y, w, h);
                    y = y + this.vGap + h;
                }
                ++i;
            }
        }
    }

    public int getHGap() {
        return this.hGap;
    }

    public int getVGap() {
        return this.vGap;
    }

    public void setHGap(int hGap) {
        this.hGap = hGap;
    }

    public void setVGap(int vGap) {
        this.vGap = vGap;
    }

    public int getAlign() {
        return this.align;
    }

    public void setAlign(int i) {
        this.align = i;
    }
}

