/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;

public class BlowVisualComponent
extends VisualComponent {
    private BasicStroke stroke = new BasicStroke(2.0f);
    private JLabel label = new JLabel();

    public BlowVisualComponent() {
        this.setLayout(new FlowLayout());
        this.setForeground(Color.BLACK);
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        this.add(this.label);
    }

    protected void paintVisual(Graphics2D g) {
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        int lw = (int)this.stroke.getLineWidth();
        int dx = x + lw / 2;
        int dy = y + lw / 2;
        int dw = w - lw - 1;
        int dh = h - lw - 1;
        Shape shape = new Arc2D.Double(dx, dy, dw, dh, -120.0, 330.0, 0);
        GeneralPath generalPath = new GeneralPath(shape);
        generalPath.lineTo(dx, dh);
        generalPath.closePath();
        shape = generalPath;
        if (this.getBackground() != null) {
            g.setColor(this.getBackground());
            g.fill(shape);
        }
        if (this.getForeground() != null) {
            g.setStroke(this.stroke);
            g.setColor(this.getForeground());
            g.draw(shape);
        }
    }

    public void setText(String text) {
        this.label.setText(text);
        this.validate();
    }

    public JLabel getLabel() {
        return this.label;
    }
}

