/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.swing.visuals;

import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class Decoration {
    public static final Shape DEFAULT_TEMPLATE = new Rectangle(0, 0, 0, 0);
    private Shape template = DEFAULT_TEMPLATE;
    private double sx = 10.0;
    private double sy = 10.0;
    private double lx = 0.0;
    private double ly = 0.0;
    private double direction = 0.0;
    private boolean dirty = true;
    private Shape cash = null;

    public static final Decoration createTriangleInstance() {
        Polygon triangle = new Polygon();
        triangle.addPoint(-1, 1);
        triangle.addPoint(1, 0);
        triangle.addPoint(-1, -1);
        Decoration decoration = new Decoration();
        decoration.setTemplate(triangle);
        return decoration;
    }

    public void setTemplate(Shape shape) {
        this.template = shape;
        this.dirty = true;
    }

    public Shape getShape() {
        if (this.dirty) {
            this.recreateShape();
            this.dirty = false;
        }
        return this.cash;
    }

    private void recreateShape() {
        AffineTransform transform = new AffineTransform();
        transform.translate(this.lx, this.ly);
        transform.rotate(this.direction);
        transform.scale(this.sx, this.sy);
        this.cash = transform.createTransformedShape(this.template);
    }

    public void setScale(double sx, double sy) {
        this.sx = sx;
        this.sy = sy;
        this.dirty = true;
    }

    public void setLocation(double lx, double ly) {
        this.lx = lx;
        this.ly = ly;
        this.dirty = true;
    }

    public void setDirection(double dx, double dy) {
        this.setDirection(Math.atan2(dy, dx));
    }

    public void setDirection(double angle) {
        this.direction = angle;
        this.dirty = true;
    }
}

