/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

public class SSelectionManager {
    private SGraphicalEditor editor;
    private ListCoordinator coordinator = new ListCoordinator(new SelectionValueChangeListener());
    private Map selectedEditParts = new LinkedHashMap();

    public SSelectionManager(SGraphicalEditor editor) {
        this.editor = editor;
    }

    public void add(SEditPart editpart) {
        if (editpart != null && !this.selectedEditParts.containsKey(editpart)) {
            List list = this.coordinator.getList();
            list.add(editpart);
            this.coordinator.setList(list);
        }
    }

    public void clearSelection() {
        this.coordinator.setList(null);
    }

    public List getSelectedEditParts() {
        return new ArrayList(this.selectedEditParts.keySet());
    }

    public boolean hasSelectedEditPart() {
        return !this.getSelectedEditParts().isEmpty();
    }

    private void addSelection(SEditPart editpart) {
        Object object = this.editor.getTreeLock();
        synchronized (object) {
            this.selectedEditParts.put(editpart, null);
            if (editpart instanceof EGraphicalEditPart) {
                ((EGraphicalEditPart)editpart).addHandle();
            }
        }
    }

    private void removeSelection(SEditPart editpart) {
        Object object = this.editor.getTreeLock();
        synchronized (object) {
            this.selectedEditParts.remove(editpart);
            if (editpart instanceof EGraphicalEditPart) {
                ((EGraphicalEditPart)editpart).removeHandle();
            }
        }
    }

    class SelectionValueChangeListener
    implements ValueChangeListener {
        SelectionValueChangeListener() {
        }

        public void valueAdded(Object model, int index) {
            SSelectionManager.this.addSelection((SEditPart)model);
        }

        public void valueRemoved(Object model) {
            SSelectionManager.this.removeSelection((SEditPart)model);
        }

        public void valueReorderd(Object model, int index) {
        }
    }
}

