/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.animation;

import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.animation.AbstractAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.animation.Path;

public class MovingAnimationThread
extends AbstractAnimationThread {
    private VisualComponent visual;
    private Path path;
    private double currentPosition;

    protected void step() {
        this.currentPosition += 1.0 / (double)this.getStepCount();
        if (this.visual != null && this.path != null) {
            Object object = this.visual.getTreeLock();
            synchronized (object) {
                this.visual.setLocationByCenter(this.path.getPoint((int)(this.currentPosition * 100.0)));
                this.visual.repaint();
                this.visualMoved();
            }
        }
        if (this.currentPosition > 1.0) {
            if (this.isLoop()) {
                this.resetCurrentPosition();
            } else {
                this.setState(3);
            }
        }
    }

    protected void prepareStart() {
        this.resetCurrentPosition();
    }

    protected void prepareStop() {
    }

    protected void visualMoved() {
    }

    private void resetCurrentPosition() {
        this.currentPosition = 0.0;
    }

    public Path getPath() {
        return this.path;
    }

    public VisualComponent getVisual() {
        return this.visual;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public void setVisual(VisualComponent component) {
        this.visual = component;
    }
}

