/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.ac.keio.sfc.crew.collection.ListCoordinator;
import jp.ac.keio.sfc.crew.collection.ValueChangeListener;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SGraphicalRootEditPart;

public abstract class SGraphicalEditPart
extends SEditPart {
    private Map accessoriesTable = new LinkedHashMap();
    private ListCoordinator accessoriesCoordinator = new ListCoordinator(new AccessoryValueChangeListener());

    public SGraphicalRootEditPart getRoot() {
        SEditPart editpart = this;
        while (editpart.getParent() != null) {
            editpart = editpart.getParent();
        }
        return (SGraphicalRootEditPart)editpart;
    }

    public SGraphicalEditor getGraphicalEditor() {
        return (SGraphicalEditor)this.getEditor();
    }

    public void setActive(boolean active) {
        this.thisSetActive(active);
        this.childrenSetActive(active);
        this.accessoriesSetActive(active);
    }

    protected void accessoriesSetActive(boolean active) {
        Iterator i = this.getAccessories().iterator();
        while (i.hasNext()) {
            SEditPart accessory = (SEditPart)i.next();
            accessory.setActive(active);
        }
    }

    public void refreshStructure() {
        this.refreshChildren();
        this.refreshAccessories();
    }

    public void refreshStructureRecursively() {
        this.refreshStructure();
        this.refreshChildrenStructure();
        this.refreshAccessoriesStructure();
    }

    public void refreshAccessoriesStructure() {
        Iterator i = this.getAccessories().iterator();
        while (i.hasNext()) {
            SEditPart child = (SEditPart)i.next();
            child.refreshStructureRecursively();
        }
    }

    public void refreshVisualRecursively() {
        this.refreshVisual();
        this.refreshChildrenVisual();
        this.refreshAccessoriesVisual();
    }

    public void refreshAccessoriesVisual() {
        Iterator i = this.getAccessories().iterator();
        while (i.hasNext()) {
            SEditPart accessory = (SEditPart)i.next();
            accessory.refreshVisualRecursively();
        }
    }

    protected List getModelAccessories() {
        return null;
    }

    public void refreshAccessories() {
        this.accessoriesCoordinator.setList(this.getModelAccessories());
    }

    public List getAccessories() {
        return new ArrayList(this.accessoriesTable.values());
    }

    protected void addAttachment(SEditPart editpart) {
        this.accessoriesTable.put(editpart.getModel(), editpart);
        editpart.setActive(this.isActive());
    }

    protected void removeAttachment(SEditPart editpart) {
        editpart.setActive(false);
        this.accessoriesTable.remove(editpart.getModel());
    }

    class AccessoryValueChangeListener
    implements ValueChangeListener {
        AccessoryValueChangeListener() {
        }

        public void valueAdded(Object model, int index) {
            SEditPart editpart = SGraphicalEditPart.this.createOrFindEditPart(model);
            SGraphicalEditPart.this.addAttachment(editpart);
        }

        public void valueRemoved(Object model) {
            SEditPart editpart = (SEditPart)SGraphicalEditPart.this.accessoriesTable.get(model);
            if (editpart != null) {
                SGraphicalEditPart.this.removeAttachment(editpart);
                SGraphicalEditPart.this.terminateEditPart(editpart);
            } else {
                SGraphicalEditPart.this.accessoriesTable.remove(model);
            }
        }

        public void valueReorderd(Object model, int index) {
        }
    }
}

