/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext;

import java.util.Iterator;
import java.util.List;
import jp.ac.keio.sfc.crew.collection.MultipleKeyMap;
import jp.ac.keio.sfc.crew.collection.MultipleValueMap;
import jp.ac.keio.sfc.crew.view.sgef.ext.EGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EConnectionEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;

public class EConnectionManager {
    private EGraphicalEditor editor;
    private MultipleKeyMap connectionsTable = new MultipleKeyMap();
    private MultipleValueMap notRegisterdTargetConnectionsTable = new MultipleValueMap();

    public EConnectionManager(EGraphicalEditor editor) {
        this.editor = editor;
    }

    public void registerEditPart(EGraphicalEditPart editpart) {
        if (editpart instanceof EConnectionEditPart) {
            this.registerConnectionEditPartImpl((EConnectionEditPart)editpart);
        } else {
            this.registerEditPartImpl(editpart);
        }
    }

    private void registerConnectionEditPartImpl(EConnectionEditPart connectionEditPart) {
        Object source = connectionEditPart.getModelSource();
        Object target = connectionEditPart.getModelTarget();
        EGraphicalEditPart targetEditPart = (EGraphicalEditPart)this.editor.getEditPart(target);
        if (targetEditPart != null) {
            targetEditPart.addTemporaryAccessories(connectionEditPart);
        } else {
            this.notRegisterdTargetConnectionsTable.put(target, connectionEditPart);
        }
        if (!this.connectionsTable.containtsValue(connectionEditPart)) {
            this.connectionsTable.put(source, target, connectionEditPart);
            this.reorderConnections(this.connectionsTable.get(source, target));
        }
    }

    private void registerEditPartImpl(EGraphicalEditPart editpart) {
        if (this.notRegisterdTargetConnectionsTable.containtsKey(editpart.getModel())) {
            List targetConnections = this.notRegisterdTargetConnectionsTable.removeByKey(editpart.getModel());
            Iterator i = targetConnections.iterator();
            while (i.hasNext()) {
                EConnectionEditPart connectionEditPart = (EConnectionEditPart)i.next();
                editpart.addTemporaryAccessories(connectionEditPart);
            }
        }
    }

    public void unregisterEditPart(EGraphicalEditPart editpart) {
        if (editpart instanceof EConnectionEditPart) {
            this.unregisterConnectionEditPartImpl((EConnectionEditPart)editpart);
        } else {
            this.unregisterEditPartImpl(editpart);
        }
    }

    public void unregisterConnectionEditPartImpl(EConnectionEditPart connectionEditPart) {
        Object source = connectionEditPart.getModelSource();
        Object target = connectionEditPart.getModelTarget();
        EGraphicalEditPart targetEditPart = (EGraphicalEditPart)this.editor.getEditPart(target);
        if (targetEditPart != null) {
            targetEditPart.removeTemporaryAccessories(connectionEditPart);
        }
        if (this.connectionsTable.containtsValue(connectionEditPart)) {
            this.connectionsTable.removeByValue(connectionEditPart);
            this.reorderConnections(this.connectionsTable.get(source, target));
        }
    }

    public void unregisterEditPartImpl(EGraphicalEditPart editpart) {
    }

    private void reorderConnections(List connections) {
        int size = connections.size();
        int i = 0;
        while (i < size) {
            EConnectionEditPart editpart = (EConnectionEditPart)connections.get(i);
            editpart.setConstraints(i, size);
            ++i;
        }
    }
}

