/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.editparts;

import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalRootEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.EConnectionVisualComponent;

public abstract class EConnectionEditPart
extends EGraphicalEditPart {
    private int index = -1;
    private int count = -1;

    protected void activate() {
        super.activate();
        this.getRoot().addVisualToLayer(this.getVisual(), this.getLayerConstants());
    }

    protected void deactivate() {
        this.getRoot().removeVisualFromLayer(this.getVisual(), this.getLayerConstants());
        super.deactivate();
    }

    public Object getLayerConstants() {
        return EGraphicalRootEditPart.LAYER_UPPER_CONNECTIONS;
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.count;
    }

    public void setConstraints(int index, int count) {
        if (this.index != index || this.count != count) {
            this.index = index;
            this.count = count;
            this.refreshVisualRecursively();
        }
    }

    public abstract Object getModelSource();

    public abstract Object getModelTarget();

    public void refreshVisual() {
        SEditPart targetEditPart;
        super.refreshVisual();
        EConnectionVisualComponent visual = (EConnectionVisualComponent)this.getVisual();
        SEditPart sourceEditPart = this.getEditor().getEditPart(this.getModelSource());
        if (sourceEditPart != null) {
            visual.setSource(sourceEditPart.getVisual());
        }
        if ((targetEditPart = this.getEditor().getEditPart(this.getModelTarget())) != null) {
            visual.setTarget(targetEditPart.getVisual());
        }
        visual.setConstraints(this.index, this.count);
        visual.refreshVisual();
    }
}

