/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.ext.visuals;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import jp.ac.keio.sfc.crew.swing.visuals.Decoration;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.EConnectionVisualComponent;

public class ELineConnectionVisualComponent
extends EConnectionVisualComponent {
    private Line2D line = new Line2D.Double();
    private BasicStroke stroke = new BasicStroke(1.0f);
    private int multipleLineInterval = 0;
    private AffineTransform transform = new AffineTransform();
    private Decoration sourceDecoration = new Decoration();
    private Decoration targetDecoration = new Decoration();

    public ELineConnectionVisualComponent() {
        this.setForeground(Color.black);
    }

    public void refreshVisual() {
        this.refreshLine();
        this.refreshDecorations();
        this.refreshConstraints();
        this.repaint();
    }

    protected void refreshLine() {
        VisualComponent source = this.getSource();
        VisualComponent target = this.getTarget();
        Point sCenterLoc = source.getAbsoluteCenterLocation();
        Point tCenterLoc = target.getAbsoluteCenterLocation();
        Rectangle sBounds = new Rectangle(source.getAbsoluteLocation(), source.getSize());
        Rectangle tBounds = new Rectangle(target.getAbsoluteLocation(), target.getSize());
        Point sAnchor = this.computeChopBoxAnchor(sBounds, tCenterLoc);
        Point tAnchor = this.computeChopBoxAnchor(tBounds, sCenterLoc);
        this.line.setLine(sAnchor, tAnchor);
    }

    protected void refreshDecorations() {
        double direction = this.computeDirection();
        this.sourceDecoration.setDirection(direction + Math.PI);
        this.sourceDecoration.setLocation(this.line.getX1(), this.line.getY1());
        this.targetDecoration.setDirection(direction);
        this.targetDecoration.setLocation(this.line.getX2(), this.line.getY2());
    }

    protected void refreshConstraints() {
        int count = this.getCount();
        int index = this.getIndex();
        AffineTransform transform = new AffineTransform();
        if (count > 1) {
            double direction;
            double interval = this.getMultipleLineInterval();
            interval = count % 2 == 0 ? (index < 2 ? (interval /= 2.0) : interval / 2.0 + interval * (double)(index / 2)) : (index == 0 ? 0.0 : (interval *= (double)((index + 1) / 2)));
            if (index % 2 != 0) {
                interval *= -1.0;
            }
            if ((direction = this.computeDirection()) > 1.5707963267948966) {
                direction += Math.PI;
            } else if (direction < -1.5707963267948966) {
                direction -= Math.PI;
            }
            double tx = Math.cos(direction += 1.5707963267948966) * interval;
            double ty = Math.sin(direction) * interval;
            transform.translate(tx, ty);
        }
        this.setTransform(transform);
    }

    protected Point computeChopBoxAnchor(Rectangle r, Point reference) {
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    protected double computeDirection() {
        double dx = this.line.getX2() - this.line.getX1();
        double dy = this.line.getY2() - this.line.getY1();
        return Math.atan2(dy, dx);
    }

    protected void paintVisual(Graphics2D g) {
        g.setColor(this.getForeground());
        Stroke defaultStroke = g.getStroke();
        g.setStroke(this.getStroke());
        AffineTransform defaultTransform = g.getTransform();
        AffineTransform transform = new AffineTransform(this.getTransform());
        transform.concatenate(g.getTransform());
        g.setTransform(transform);
        g.draw(this.line);
        g.fill(this.sourceDecoration.getShape());
        g.fill(this.targetDecoration.getShape());
        GeneralPath path = new GeneralPath(this.line);
        g.setStroke(defaultStroke);
        g.setTransform(defaultTransform);
    }

    public Line2D getLine() {
        return this.line;
    }

    public Rectangle getLineBounds() {
        return this.transform.createTransformedShape(this.line).getBounds();
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    public void setTransform(AffineTransform transform) {
        this.transform = transform;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
    }

    public Decoration getSourceDecoration() {
        return this.sourceDecoration;
    }

    public Decoration getTargetDecoration() {
        return this.targetDecoration;
    }

    public void setSourceDecoration(Decoration decoration) {
        this.sourceDecoration = decoration;
    }

    public void setTargetDecoration(Decoration decoration) {
        this.targetDecoration = decoration;
    }

    public int getMultipleLineInterval() {
        return this.multipleLineInterval;
    }

    public void setMultipleLineInterval(int interval) {
        this.multipleLineInterval = interval;
    }
}

