/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.keio.sfc.crew.view.sgef.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.SGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.tools.SEditingTool;

public class SSelectionTool
extends SEditingTool
implements MouseListener {
    private SEditPart selectedEditPart;

    public SSelectionTool(SGraphicalEditor editor) {
        super(editor);
    }

    protected void activate() {
        this.getEditor().getRootLayer().addMouseListener(this);
    }

    protected void deactivate() {
        this.getEditor().getRootLayer().removeMouseListener(this);
    }

    public void mouseClicked(MouseEvent e) {
        this.unselection(e);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.selection(e);
    }

    public void mouseReleased(MouseEvent e) {
    }

    private void selection(MouseEvent e) {
        VisualComponent selectedVisual = this.getDeepestSelectableComponent(this.getEditor().getContentsLayer(), e.getX(), e.getY());
        this.selectedEditPart = this.getEditor().getEditPart(selectedVisual);
        if (!(this.getEditor().getSelectedEditParts().contains(this.selectedEditPart) || e.isControlDown() || e.isShiftDown())) {
            this.getEditor().clearSelection();
        }
        if (this.selectedEditPart != null) {
            this.getEditor().addSelectedEditPart(this.selectedEditPart);
        }
    }

    private void unselection(MouseEvent e) {
        if (!e.isControlDown() && !e.isShiftDown()) {
            this.getEditor().clearSelection();
        }
        if (this.selectedEditPart != null) {
            this.getEditor().addSelectedEditPart(this.selectedEditPart);
        }
    }

    private VisualComponent getDeepestSelectableComponent(Component parent, int x, int y) {
        if (!parent.contains(x, y)) {
            return null;
        }
        if (parent instanceof Container) {
            Component[] components = ((Container)parent).getComponents();
            int i = 0;
            while (i < components.length) {
                Component child = components[i];
                if (child != null && child.isVisible()) {
                    Point loc = child.getLocation();
                    if ((child = child instanceof Container ? this.getDeepestSelectableComponent(child, x - loc.x, y - loc.y) : child.getComponentAt(x - loc.x, y - loc.y)) != null && child.isVisible() && this.isSelectable(child)) {
                        return (VisualComponent)child;
                    }
                }
                ++i;
            }
        }
        if (parent instanceof VisualComponent && parent.isVisible() && this.isSelectable(parent)) {
            return (VisualComponent)parent;
        }
        return null;
    }

    private boolean isSelectable(Component component) {
        if (component instanceof VisualComponent) {
            VisualComponent visual = (VisualComponent)component;
            SEditPart editpart = this.getEditor().getEditPart(visual);
            if (editpart != null && editpart.isSelectable()) {
                return true;
            }
        }
        return false;
    }
}

