/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class BESPLauncher {
    public static final String PLUGINDIR = "plugins";
    public static final String CLASSPATH_SEPARATOR = File.pathSeparator;
    public static final String JAR_EXTENSION = ".jar";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String OS_KEY = "os.name";
    public static final String OPTION_CLASSPATH = "-classpath";
    public static final String OPTION_PRINT = "-print";
    public static final String OPTION_BOXHOME = "-home";
    public static final String OPTION_LOGPROPERTYFILE = "-logbyfile";
    public static final String OPTION_LOG = "-log";
    public static final String OPTION_MODEL = "-model";
    public static final String OPTION_LOCALE = "-locale";
    public static final String OPTION_HELP = "-help";
    public static final String OPTION_DEBUG = "-debug";
    private String boxHome = System.getProperty("user.dir");
    private String currentClasspath = System.getProperty("java.class.path");
    private Collection classpaths = new TreeSet();
    private Map argMap = new HashMap();
    private Process process = null;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        BESPLauncher besp = new BESPLauncher();
        besp.launch(args);
    }

    private void launch(String[] args) {
        try {
            String argStr = this.listToString(Arrays.asList(args), " ");
            System.out.println("BESPLauncer start .....................  ");
            System.out.println("args = " + argStr);
            this.initializeArguments(args);
            this.showHelp();
            this.initializeBoxHome();
            this.initializeClasspath();
            this.boot(args);
            if (this.isPrint()) {
                this.startPrintThread();
                this.waitForBESP();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initializeArguments(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (i + 1 < args.length) {
                    this.argMap.put(args[i], args[i + 1]);
                } else {
                    this.argMap.put(args[i], null);
                }
            }
            ++i;
        }
    }

    private void showHelp() {
        if (this.argMap.containsKey(OPTION_HELP)) {
            System.out.println("-HELP COMMENTS-");
            System.out.println("[-classpath] add JAVA-CLASSPATH entries.");
            System.out.println("[-help]      show this Help.");
            System.out.println("[-home]      set Box Home Directory.(default is User Directory(" + System.getProperty("user.dir") + ")");
            System.out.println("[-locale]    set locale(define standard locale format. ex) ja_JP)");
            System.out.println("[-logconf]   set Log Configulation file (default is Basic-Configulation log4j)");
            System.out.println("[-model]     set First Load Model Class(By Class Name or .box File )");
            System.out.println("[-print]     output texts.(Log ,Error,Information etc...)");
            System.exit(0);
        }
    }

    private void initializeBoxHome() {
        if (this.argMap.containsKey(OPTION_BOXHOME)) {
            this.boxHome = (String)this.argMap.get(OPTION_BOXHOME);
        }
    }

    private boolean isPrint() {
        return this.argMap.containsKey(OPTION_PRINT);
    }

    private void initializeClasspath() {
        this.searchClasspathFromDirectory(new File(this.boxHome, PLUGINDIR));
        this.searchClasspathFromArgument(this.currentClasspath);
        this.searchClasspathFromArgument(this.searchClasspathOption());
    }

    private void searchClasspathFromDirectory(File f) {
        if (f.isDirectory()) {
            File[] fileList = f.listFiles();
            int i = 0;
            while (i < fileList.length) {
                this.searchClasspathFromDirectory(fileList[i]);
                ++i;
            }
        } else {
            String fileName = f.getName();
            if (fileName.endsWith(JAR_EXTENSION) || fileName.endsWith(ZIP_EXTENSION)) {
                this.classpaths.add(f.getAbsoluteFile().toString());
            }
        }
    }

    private void searchClasspathFromArgument(String classpath) {
        StringTokenizer tokenizer = new StringTokenizer(classpath, CLASSPATH_SEPARATOR);
        while (tokenizer.hasMoreTokens()) {
            this.classpaths.add(tokenizer.nextToken());
        }
    }

    private String searchClasspathOption() {
        if (this.argMap.containsKey(OPTION_CLASSPATH)) {
            return (String)this.argMap.get(OPTION_CLASSPATH);
        }
        return "";
    }

    private String createClasspathString() {
        String classpath = this.listToString(new ArrayList(this.classpaths), CLASSPATH_SEPARATOR);
        if (System.getProperty(OS_KEY).startsWith("Windows")) {
            classpath = "\"" + classpath + "\"";
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append('\u0006');
            classpath = classpath.replaceAll(" ", buf.toString());
        }
        return classpath;
    }

    private String createCommand(String[] args) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getJavaCommand());
        commands.add(OPTION_CLASSPATH);
        commands.add(this.createClasspathString());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.container.BESP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        commands.add(clazz.getName());
        int i = 0;
        while (i < args.length) {
            commands.add(args[i]);
            ++i;
        }
        return this.listToString(commands, " ");
    }

    private String listToString(List list, String delim) {
        StringBuffer buf = new StringBuffer();
        int len = list.size();
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(delim);
            }
            buf.append(list.get(i));
            ++i;
        }
        return buf.toString();
    }

    private void boot(String[] args) throws Exception {
        String command = this.createCommand(args);
        System.out.println("BESP booting by BESPLauncher command = " + command);
        this.process = Runtime.getRuntime().exec(command);
    }

    private String getJavaCommand() {
        if (System.getProperty(OS_KEY).startsWith("Windows")) {
            return "javaw";
        }
        return "java";
    }

    private void waitForBESP() throws Exception {
        this.process.waitFor();
    }

    private void startPrintThread() throws InterruptedException {
        PrintThread out = new PrintThread();
        out.input = this.process.getInputStream();
        out.output = System.out;
        out.start();
        PrintThread err = new PrintThread();
        err.input = this.process.getErrorStream();
        err.output = System.err;
        err.start();
    }

    class PrintThread
    extends Thread {
        InputStream input;
        PrintStream output;

        PrintThread() {
        }

        public void run() {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
                String buf = "";
                while ((buf = br.readLine()) != null) {
                    this.output.println(buf);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

