/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.container;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.boxed_economy.besp.container.ArgumentManager;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.container.PropertyManager;
import org.boxed_economy.besp.container.classtree.BoxClassTreeCreator;
import org.boxed_economy.besp.container.classtree.BoxRootPackage;
import org.boxed_economy.besp.container.classtree.CleaningInvalidClassBoxClassTreeVisitor;
import org.boxed_economy.besp.container.command.Command;
import org.boxed_economy.besp.container.command.FileOpenCommand;
import org.boxed_economy.besp.container.command.ImportWorldCommand;

public class BESP {
    private static final Logger logger;
    public static final String EXTENSION = ".box";
    public static final String VERSION = "v1.2.2 (build 2004/06/07)";
    public static final String COPYRIGHT = "Copyright(c) 2000-2004 Boxed Economy Project";
    public static final String LOG_CONSOLE = "console";
    public static final String LOG_FILE = "file";
    public static final String LOG_GUI = "gui";
    public static final String LOG_PROPERTYFILE = "propertyfile";
    public static ResourceBundle resource;
    public static String boxHome;
    public static BoxRootPackage classTreeRoot;
    public static BESPContainer container;
    public static ArgumentManager argument;
    public static PropertyManager property;
    public static boolean DEBUG;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.container.BESP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        resource = null;
        boxHome = System.getProperty("user.dir");
        classTreeRoot = null;
        container = null;
        argument = null;
        property = null;
        DEBUG = false;
    }

    public static void main(String[] args) {
        try {
            BESP.initializeArguments(args);
            BESP.initialize();
            BESP.loadFirstModel(BESP.argument.modelName);
        }
        catch (Exception ex) {
            logger.warn((Object)"initalize failed", (Throwable)ex);
            ex.printStackTrace();
            BESP.terminate();
        }
    }

    private static void initializeArguments(String[] args) {
        argument = new ArgumentManager();
        argument.initializeArguments(args);
    }

    private static void initialize() throws Exception {
        BESP.initializeResource();
        BESP.initializeLog();
        BESP.message();
        container = BESP.createContainer();
        container.getPresentationContainer().showTitle();
        container.getPresentationContainer().setInitialStatusMessage(resource.getString("initializeProperty"));
        BESP.initializeProperty();
        container.getPresentationContainer().setInitialStatusMessage(resource.getString("initializeClassTree"));
        BESP.initializeClassTree();
        container.getPresentationContainer().setInitialStatusMessage(resource.getString("initializeContainer"));
        BESP.initializeContainer();
        container.getPresentationContainer().hideTitle();
    }

    public static void terminate() {
        if (container != null) {
            container.terminate();
        }
        if (property != null) {
            property.save();
        }
        System.exit(0);
    }

    private static void message() {
        logger.info((Object)"Hello! Boxed Economy Simulation Platform(BESP)");
        argument.log();
    }

    private static void initializeResource() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.boxed_economy.besp.container.BESPResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        resource = ResourceBundle.getBundle(clazz.getName());
    }

    public static void initializeLog() throws Exception {
        block6: {
            if (BESP.argument.logType.equals(LOG_PROPERTYFILE)) {
                PropertyConfigurator.configure((String)BESP.argument.logPropertyFileName);
                logger.info((Object)("Log Initialized by PropertyFile = " + BESP.argument.logPropertyFileName));
                break block6;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.boxed_economy.besp.container.BESP");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            PropertyConfigurator.configure((URL)clazz.getResource("log4j." + BESP.argument.logType + ".properties"));
            logger.info((Object)("Log Initialized by " + BESP.argument.logType));
        }
    }

    private static BESPContainer createContainer() throws Exception {
        return new BESPContainer();
    }

    private static void initializeProperty() {
        property = new PropertyManager();
        property.load();
    }

    private static void initializeClassTree() {
        BoxClassTreeCreator creator = new BoxClassTreeCreator();
        classTreeRoot = creator.createFromClassPath();
        CleaningInvalidClassBoxClassTreeVisitor cleaner = new CleaningInvalidClassBoxClassTreeVisitor();
        cleaner.treewalk(classTreeRoot);
    }

    private static void initializeContainer() throws Exception {
        container.initialize();
    }

    private static void loadFirstModel(String firstModel) throws Exception {
        if (firstModel == null || firstModel.length() == 0) {
            return;
        }
        Command com = null;
        com = firstModel.endsWith(EXTENSION) ? new FileOpenCommand(container, new File(firstModel)) : new ImportWorldCommand(container, firstModel);
        com.execute();
    }
}

