/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.Entry;

public class PropertyManager {
    private static final Logger logger;
    private static final String FILENAME = ".properties";
    private Map properties = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.container.PropertyManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public void put(Class clazz, Serializable property) {
        this.properties.put(clazz.getName(), property);
    }

    public Object get(Class clazz) {
        return this.properties.get(clazz.getName());
    }

    void load() {
        try {
            ObjectInputStream stream = new ObjectInputStream(new FileInputStream(this.getFile()));
            int size = stream.readInt();
            int i = 0;
            while (i < size) {
                try {
                    Entry entry = (Entry)stream.readObject();
                    this.properties.put(entry.key, entry.value);
                }
                catch (Exception ex) {
                    logger.warn((Object)"the property is broken", (Throwable)ex);
                }
                ++i;
            }
            stream.close();
        }
        catch (FileNotFoundException ex) {
            logger.info((Object)"properties file not found , creating new one");
            this.properties = new HashMap();
        }
        catch (Exception ex) {
            logger.warn((Object)"properties file is broken , creating new one", (Throwable)ex);
            this.properties = new HashMap();
        }
    }

    void save() {
        try {
            ObjectOutputStream stream = new ObjectOutputStream(new FileOutputStream(this.getFile()));
            Set entrySet = this.properties.entrySet();
            stream.writeInt(entrySet.size());
            Iterator i = entrySet.iterator();
            while (i.hasNext()) {
                Map.Entry mapEntry = i.next();
                try {
                    Entry entry = new Entry();
                    entry.key = mapEntry.getKey();
                    entry.value = mapEntry.getValue();
                    stream.writeObject(entry);
                }
                catch (Exception ex) {
                    logger.warn((Object)("the property " + mapEntry.getKey() + "is cannot save because = "), (Throwable)ex);
                }
            }
            stream.close();
        }
        catch (Exception ex) {
            logger.warn((Object)"properties file cannot save because = ", (Throwable)ex);
        }
    }

    private File getFile() {
        return new File(String.valueOf(BESP.boxHome) + File.separator + FILENAME);
    }
}

