/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.ModelThread;
import org.boxed_economy.besp.model.PriorityManager;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.FMFWConstants;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.TypeManager;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.PresentationContainer;

public class ModelContainer {
    private static final Logger logger;
    public static final int PRIORITY_DEFAULT = 0;
    private BESPContainer container = null;
    private World model = null;
    private File file = null;
    private ModelThread modelThread = new ModelThread(this);
    private TypeManager vocabulary = new TypeManager();
    private PriorityManager priorityManager = new PriorityManager();
    private Vector modelContainerListeners;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.ModelContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.besp.model.ModelContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public ModelContainer(BESPContainer container) {
        this.container = container;
    }

    public void initialize() {
        FMFWConstants.initialize(this);
        this.installInformationTypes();
        this.installBehaviorTypes();
    }

    private void installInformationTypes() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.boxed_economy.besp.model.fmfw.Information");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List classes = BESP.classTreeRoot.getFilteredClasses(clazz);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            Class clazz2 = (Class)i.next();
            this.installInformationType(clazz2.getName());
        }
    }

    private void installBehaviorTypes() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.boxed_economy.besp.model.fmfw.Behavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List classes = BESP.classTreeRoot.getFilteredClasses(clazz);
        Iterator i = classes.iterator();
        while (i.hasNext()) {
            Class clazz2 = (Class)i.next();
            this.installBehaviorType(clazz2.getName());
        }
    }

    public void terminate() {
    }

    public BESPContainer getContainer() {
        return this.container;
    }

    public PresentationContainer getPresentationContainer() {
        return this.getContainer().getPresentationContainer();
    }

    public World getModel() {
        return this.model;
    }

    public void setModel(final World model) {
        if (!$assertionsDisabled && this.getModelThread().getState() != 1) {
            throw new AssertionError();
        }
        Thread setModelThread = new Thread(){

            public void run() {
                if (ModelContainer.this.model != null) {
                    ModelContainer.this.finalizeWorld(ModelContainer.this.model);
                }
                ModelContainer.this.initializeWorld(model);
            }
        };
        setModelThread.start();
    }

    private void finalizeWorld(World model) {
        this.firePrepareWorldClose(new ModelContainerEvent(this, model));
        this.model = null;
        this.fireWorldClosed(new ModelContainerEvent(this, model));
    }

    private void initializeWorld(World model) {
        if (!$assertionsDisabled && model == null) {
            throw new AssertionError();
        }
        this.model = model;
        this.model.setModelContainer(this);
        this.firePrepareWorldOpen(new ModelContainerEvent(this, this.model));
        this.model.initialize();
        this.fireWorldOpened(new ModelContainerEvent(this, this.model));
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public ModelThread getModelThread() {
        return this.modelThread;
    }

    public LimitedTimeRunSetting getLimitedTimeRunSetting() {
        return this.modelThread.getLimitedRunSetting();
    }

    public void setLimitedRunSetting(LimitedTimeRunSetting setting) {
        this.modelThread.setLimitedRunSetting(setting);
    }

    public AgentType getAgentType(String key) {
        return this.vocabulary.getAgentType(key);
    }

    public BehaviorType getBehaviorType(String key) {
        return this.vocabulary.getBehaviorType(key);
    }

    public GoodsType getGoodsType(String key) {
        return this.vocabulary.getGoodsType(key);
    }

    public InformationType getInformationType(String key) {
        return this.vocabulary.getInformationType(key);
    }

    public RelationType getRelationType(String key) {
        return this.vocabulary.getRelationType(key);
    }

    public Collection getAgentTypes() {
        return this.vocabulary.getAgentTypes();
    }

    public Collection getBehaviorTypes() {
        return this.vocabulary.getBehaviorTypes();
    }

    public Collection getGoodsTypes() {
        return this.vocabulary.getGoodsTypes();
    }

    public Collection getInformationTypes() {
        return this.vocabulary.getInformationTypes();
    }

    public Collection getRelationTypes() {
        return this.vocabulary.getRelationTypes();
    }

    public AgentType installAgentType(String name) {
        return this.installAgentType(name, 0);
    }

    public AgentType installAgentType(String name, int priority) {
        AgentType type = this.vocabulary.installAgentType(name);
        this.setPriority(type, priority);
        return type;
    }

    public GoodsType installGoodsType(String name) {
        return this.vocabulary.installGoodsType(name);
    }

    public BehaviorType installBehaviorType(String name) {
        return this.vocabulary.installBehaviorType(name);
    }

    public RelationType installRelationType(String name) {
        return this.vocabulary.installRelationType(name);
    }

    public InformationType installInformationType(String name) {
        return this.vocabulary.installInformationType(name);
    }

    public int getPriority(AgentType agentType) {
        return this.priorityManager.getPriority(agentType);
    }

    public void setPriority(AgentType agentType, int priority) {
        this.priorityManager.setPriority(agentType, priority);
    }

    public List getOrderdPriorities() {
        return this.priorityManager.getOrderdPriorities();
    }

    public synchronized void addModelContainerListener(ModelContainerListener l) {
        Vector v;
        Vector vector = v = this.modelContainerListeners == null ? new Vector(2) : (Vector)this.modelContainerListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.modelContainerListeners = v;
        }
    }

    public synchronized void removeModelContainerListener(ModelContainerListener l) {
        if (this.modelContainerListeners != null && this.modelContainerListeners.contains(l)) {
            Vector v = (Vector)this.modelContainerListeners.clone();
            v.removeElement(l);
            this.modelContainerListeners = v;
        }
    }

    protected void firePrepareWorldOpen(ModelContainerEvent e) {
        if (this.modelContainerListeners != null) {
            Vector listeners = this.modelContainerListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ModelContainerListener)listeners.elementAt(i)).prepareWorldOpen(e);
                ++i;
            }
        }
    }

    protected void fireWorldOpened(ModelContainerEvent e) {
        if (this.modelContainerListeners != null) {
            Vector listeners = this.modelContainerListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ModelContainerListener)listeners.elementAt(i)).worldOpened(e);
                ++i;
            }
        }
    }

    protected void firePrepareWorldClose(ModelContainerEvent e) {
        if (this.modelContainerListeners != null) {
            Vector listeners = this.modelContainerListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ModelContainerListener)listeners.elementAt(i)).prepareWorldClose(e);
                ++i;
            }
        }
    }

    protected void fireWorldClosed(ModelContainerEvent e) {
        if (this.modelContainerListeners != null) {
            Vector listeners = this.modelContainerListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ModelContainerListener)listeners.elementAt(i)).worldClosed(e);
                ++i;
            }
        }
    }
}

