/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.Priority;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.DefaultRandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.World;

public class ModelThread
implements Runnable {
    private static final Logger logger;
    public static final int STOPPED = 1;
    public static final int STOPPING = 2;
    public static final int RUNNING = 3;
    private static final String THREAD_NAME = "modelThread";
    private static final int THREAD_PRIORITY_DEFAULT = 4;
    private static final int EVENT_DISPATCH_INTERVAL_DEFALUT = 100;
    private ModelContainer modelContainer = null;
    private volatile int state = 1;
    private long eventDispatchInterval = 100L;
    private long runStepNum = 0L;
    private Thread thread = null;
    private LimitedTimeRunSetting setting = null;
    protected Vector simulationStateListeners = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.ModelThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.besp.model.ModelThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public ModelThread(ModelContainer modelContainer) {
        this.modelContainer = modelContainer;
    }

    public int getState() {
        return this.state;
    }

    private void setState(int state) {
        if (this.state != state) {
            logger.debug((Object)("transition " + this.state + "=>" + state));
            this.state = state;
            this.fireSimulationStateEvent();
        }
    }

    private void fireSimulationStateEvent() {
        SimulationStateEvent ev = new SimulationStateEvent(this);
        switch (this.state) {
            case 3: {
                this.firePresentationComponentStarted(ev);
                break;
            }
            case 2: {
                this.firePresentationComponentStopping(ev);
                break;
            }
            case 1: {
                this.firePresentationComponentStopped(ev);
                break;
            }
            default: {
                throw new ModelException("illegal state set at model executer");
            }
        }
    }

    public synchronized void start() throws Exception {
        this.start(Long.MAX_VALUE);
    }

    public synchronized void start(long step) throws Exception {
        logger.debug((Object)("start() step=" + step));
        if (step < 0L) {
            logger.warn((Object)("cannot start because step is too small (step = " + step + ") "));
            return;
        }
        this.runStepNum = step;
        if (this.thread != null) {
            logger.warn((Object)"modelThread#threadstart \u5b8c\u5168\u306bstop\u3057\u3066\u3044\u306a\u3044\u306e\u3067start\u3067\u304d\u307e\u305b\u3093\u3002");
            return;
        }
        this.setState(3);
        this.thread = new Thread((Runnable)this, THREAD_NAME);
        this.thread.setPriority(4);
        this.thread.start();
        this.wait();
        logger.debug((Object)("modelThread#threadstart() start\u3057\u307e\u3057\u305f,\u30b7\u30b9\u30c6\u30e0hour=" + System.currentTimeMillis()));
    }

    public synchronized void stop() {
        logger.debug((Object)"thread stop()  called");
        if (this.getState() == 3) {
            this.setState(2);
            this.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ModelThread.logger.debug((Object)"run() start");
        try {
            try {
                runNum = 0L;
                var3_3 = this;
                synchronized (var3_3) {
                    this.setState(3);
                    this.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 4] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                    if (true) ** GOTO lbl26
                }
                do {
                    ModelThread.logger.debug((Object)("before wait " + this.eventDispatchInterval));
                    var3_3 = this;
                    synchronized (var3_3) {
                        this.wait(this.eventDispatchInterval);
                    }
                    ModelThread.logger.debug((Object)"after wait");
                    this.deliverTimeEvent();
                    ++runNum;
lbl26:
                    // 2 sources

                } while (this.state == 3 && runNum < this.runStepNum);
            }
            catch (Exception ex) {
                this.modelContainer.getPresentationContainer().showError("Exception in ModelThread EventLoop", ex);
            }
        }
        catch (Throwable var5_4) {
            var4_5 = null;
            this.thread = null;
            this.setState(1);
            throw var5_4;
        }
        var4_6 = null;
        this.thread = null;
        this.setState(1);
        ModelThread.logger.debug((Object)"run() end");
    }

    protected LimitedTimeRunSetting getLimitedRunSetting() {
        return this.setting;
    }

    protected void setLimitedRunSetting(LimitedTimeRunSetting setting) {
        this.setting = setting;
    }

    private void deliverTimeEvent() {
        if (this.modelContainer != null && this.modelContainer.getModel() != null) {
            this.deliverTimeEvent(this.modelContainer.getModel());
        }
    }

    public void deliverTimeEvent(World world) {
        Clock clock = world.getClock();
        if (clock != null) {
            clock.prepareStep();
        }
        List pList = this.modelContainer.getOrderdPriorities();
        Collections.sort(pList);
        Iterator i = pList.iterator();
        while (i.hasNext()) {
            Priority p = (Priority)i.next();
            Iterator j = this.shuffledAgentList(p).iterator();
            while (j.hasNext()) {
                Agent agent = (Agent)j.next();
                agent.receiveTimeEvent(new TimeEvent(this));
            }
        }
        if (clock != null) {
            clock.receiveTimeEvent(new TimeEvent(this));
        }
    }

    private synchronized List shuffledAgentList(Priority priority) {
        ArrayList targetAgents = new ArrayList();
        Iterator i = priority.getAgentTypes().iterator();
        while (i.hasNext()) {
            AgentType at = (AgentType)i.next();
            Collection agents = this.modelContainer.getModel().getAgents(at);
            targetAgents.addAll(agents);
        }
        ArrayList value = new ArrayList(targetAgents);
        RandomNumberGenerator gen = this.modelContainer.getModel().getRandomNumberGenerator("timeEventRandom");
        Random random = ((DefaultRandomNumberGenerator)gen).getRandom();
        Collections.shuffle(value, random);
        return value;
    }

    public long getEventDispatchInterval() {
        return this.eventDispatchInterval;
    }

    public synchronized void setEventDispatchInterval(long interval) {
        if (!$assertionsDisabled && this.getState() != 1) {
            throw new AssertionError();
        }
        if (interval < 1L) {
            throw new IllegalArgumentException("Cannot Set EventDispathInterval below Zero");
        }
        this.eventDispatchInterval = interval;
        logger.info((Object)("Set EventDispatchInterval = " + this.eventDispatchInterval));
    }

    public synchronized void addSimulationStateListener(SimulationStateListener l) {
        Vector v;
        Vector vector = v = this.simulationStateListeners == null ? new Vector(2) : (Vector)this.simulationStateListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.simulationStateListeners = v;
        }
    }

    public synchronized void removeSimulationStateListener(SimulationStateListener l) {
        if (this.simulationStateListeners != null && this.simulationStateListeners.contains(l)) {
            Vector v = (Vector)this.simulationStateListeners.clone();
            v.removeElement(l);
            this.simulationStateListeners = v;
        }
    }

    protected void firePresentationComponentStarted(SimulationStateEvent e) {
        if (this.simulationStateListeners != null) {
            Vector listeners = this.simulationStateListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SimulationStateListener)listeners.elementAt(i)).simulationStarted(e);
                ++i;
            }
        }
    }

    protected void firePresentationComponentStopping(SimulationStateEvent e) {
        if (this.simulationStateListeners != null) {
            Vector listeners = this.simulationStateListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SimulationStateListener)listeners.elementAt(i)).simulationStopping(e);
                ++i;
            }
        }
    }

    protected void firePresentationComponentStopped(SimulationStateEvent e) {
        if (this.simulationStateListeners != null) {
            Vector listeners = this.simulationStateListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((SimulationStateListener)listeners.elementAt(i)).simulationStopped(e);
                ++i;
            }
        }
    }
}

