/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;

public class AgentManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private HashMap agentMap = new LinkedHashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.AgentManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected AgentManager() {
    }

    public void addAgent(Agent newAgent) {
        this.addAgentToMap(newAgent);
    }

    public void removeAgent(Agent target) {
        this.removeAgentFromMap(target);
    }

    public Agent getAgent(AgentType type) {
        Collection c = this.getAgents(type);
        if (c.isEmpty()) {
            throw new ModelException(String.valueOf(type.toString()) + "is not existed !");
        }
        return (Agent)c.iterator().next();
    }

    public Collection getAgents(AgentType type) {
        logger.debug((Object)"IN");
        List value = (List)this.agentMap.get(type);
        if (value == null || value.isEmpty() || value.size() == 0) {
            logger.debug((Object)"OUT(No Agent)");
            return new ArrayList();
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    public List getAgentsRecursively(AgentType type) {
        logger.debug((Object)"IN");
        List value = (List)this.getAgents(type);
        Iterator i = type.getChildrenRecursively().iterator();
        while (i.hasNext()) {
            AgentType t = (AgentType)i.next();
            value.addAll(this.getAgents(t));
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    public List getAllAgents() {
        logger.debug((Object)"IN");
        ArrayList value = new ArrayList();
        Iterator i = this.agentMap.values().iterator();
        while (i.hasNext()) {
            List l = (List)i.next();
            value.addAll(l);
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    private void addAgentToMap(Agent agent) {
        logger.debug((Object)"IN");
        ArrayList<Agent> list = (ArrayList<Agent>)this.agentMap.get(agent.getType());
        if (list != null) {
            if (list.contains(agent)) {
                list.remove(agent);
            }
            list.add(agent);
        } else {
            list = new ArrayList<Agent>();
            list.add(agent);
            this.agentMap.put(agent.getType(), list);
        }
        logger.debug((Object)"OUT");
    }

    private void removeAgentFromMap(Agent agent) {
        logger.debug((Object)"IN");
        List list = (List)this.agentMap.get(agent.getType());
        if (list != null) {
            if (!list.contains(agent)) {
                logger.debug((Object)"OUT(Exception");
                throw new ModelException("AbstractBehavior not found ! " + agent);
            }
        } else {
            throw new ModelException("AbstractBehavior Type not found ! " + agent);
        }
        list.remove(agent);
        logger.debug((Object)"OUT");
    }
}

