/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Channel;
import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.ChannelManager;
import org.boxed_economy.besp.model.fmfw.FMFWConstants;
import org.boxed_economy.besp.model.fmfw.FmFwObject;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.ReceivedGoodsManager;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorEvent;

public abstract class Behavior
extends FmFwObject {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private transient BehaviorType type = null;
    private Agent agent = null;
    private ChannelManager channelManager = new ChannelManager();
    private ReceivedGoodsManager receivedGoodsManager = new ReceivedGoodsManager(this);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.Behavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.Behavior");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public BehaviorType getType() {
        return this.type;
    }

    public final void setType(BehaviorType type) {
        this.type = type;
    }

    public World getWorld() {
        if (!$assertionsDisabled && this.agent == null && this.agent.getWorld() == null) {
            throw new AssertionError();
        }
        return this.agent.getWorld();
    }

    public Agent getAgent() {
        if (!$assertionsDisabled && this.agent == null) {
            throw new AssertionError();
        }
        return this.agent;
    }

    final void setAgent(Agent agent) {
        this.agent = agent;
    }

    public abstract State getState();

    public Channel getActiveChannel() {
        return this.channelManager.getActiveChannel();
    }

    final void setActiveChannel(Channel channel) {
        this.channelManager.setActiveChannel(channel);
    }

    final void removeChannel(Channel channel) {
        this.channelManager.removeChannel(channel);
    }

    public List getAllChannels() {
        return this.channelManager.getAllChannels();
    }

    protected abstract void run();

    protected abstract void stop();

    protected abstract boolean isReceivableEvent(Event var1);

    protected abstract void receiveEvent(Event var1);

    public final void sendGoods(Goods goods) {
        Channel channel = this.getActiveChannel();
        if (channel == null) {
            throw new ModelException("cannot sendGoods because channel is null");
        }
        channel.sendGoods(goods, this);
    }

    public final void sendGoods(Relation relation, BehaviorType behaviorType, Goods goods, boolean keep) {
        boolean opened = relation.openChannel(this, behaviorType, keep);
        if (opened) {
            this.sendGoods(goods);
        }
    }

    protected final void sendGoods(Relation relation, BehaviorType behaviorType, Goods goods) {
        this.sendGoods(relation, behaviorType, goods, false);
    }

    public final void sendInformation(Information information) {
        this.sendGoods(this.createDefaultGoods(information));
    }

    public final void sendInformation(Relation relation, BehaviorType behaviorType, Information information, boolean keep) {
        this.sendGoods(relation, behaviorType, this.createDefaultGoods(information), keep);
    }

    public final void sendInformation(Relation relation, BehaviorType behaviorType, Information information) {
        this.sendInformation(relation, behaviorType, information, false);
    }

    public final int sendInformation(RelationType relationType, BehaviorType behaviorType, Information information) {
        return this.sendInformation(relationType, behaviorType, information, false);
    }

    public final int sendInformation(RelationType relationType, BehaviorType behaviorType, Information information, boolean keep) {
        int count = 0;
        Collection relations = this.getAgent().getRelations(relationType);
        Iterator i = relations.iterator();
        while (i.hasNext()) {
            Goods goods = this.createDefaultGoods(information);
            this.sendGoods((Relation)i.next(), behaviorType, goods, keep);
            ++count;
        }
        return count;
    }

    public final void sendInformation(InformationType key, Information information) {
        this.sendGoods(this.createDefaultGoods(key, information));
    }

    public final int sendInformation(RelationType relationType, BehaviorType behaviorType, InformationType key, Information information, boolean keep) {
        int count = 0;
        Collection relations = this.getAgent().getRelations(relationType);
        Iterator i = relations.iterator();
        while (i.hasNext()) {
            Goods goods = this.createDefaultGoods(key, information);
            this.sendGoods((Relation)i.next(), behaviorType, goods, keep);
            ++count;
        }
        return count;
    }

    private Goods createDefaultGoods(InformationType key, Information information) {
        Goods goods = new Goods(FMFWConstants.GOODSTYPE_DEFAULT, 1.0);
        goods.setWorld(this.getWorld());
        goods.setAttachment(key, information);
        return goods;
    }

    private Goods createDefaultGoods(Information information) {
        Goods goods = new Goods(FMFWConstants.GOODSTYPE_DEFAULT, 1.0);
        goods.setWorld(this.getWorld());
        goods.setAttachment(information);
        return goods;
    }

    protected final int sendGoods(RelationType relationType, BehaviorType behaviorType, GoodsType goodsType, double goodsQuantity, boolean createGoods) {
        return this.sendGoods(relationType, behaviorType, goodsType, goodsQuantity, createGoods, false);
    }

    protected final int sendGoods(RelationType relationType, BehaviorType behaviorType, GoodsType goodsType, double goodsQuantity, boolean createGoods, boolean keep) {
        int count = 0;
        Collection relations = this.getAgent().getRelations(relationType);
        Iterator i = relations.iterator();
        while (i.hasNext()) {
            Goods goods = this.getGoods(goodsType, goodsQuantity, createGoods);
            this.sendGoods((Relation)i.next(), behaviorType, goods, keep);
            ++count;
        }
        return count;
    }

    private Goods getGoods(GoodsType goodsType, double goodsQuantity, boolean createGoods) {
        if (createGoods) {
            return this.getWorld().createGoods(goodsType, goodsQuantity);
        }
        return this.getAgent().removeGoods(goodsType, goodsQuantity);
    }

    public void keepReceivedGoods() {
        this.receivedGoodsManager.keepReceivedGoods();
    }

    public void setReceivedGoods(ChannelEvent event) {
        this.receivedGoodsManager.setReceivedGoods(event);
    }

    public Goods getReceivedGoods() {
        return this.receivedGoodsManager.getReceivedGoods();
    }

    public Information getReceivedInformation() {
        Goods receivedGoods = this.getReceivedGoods();
        if (!receivedGoods.hasAttachment()) {
            throw new ModelException("The goods (" + receivedGoods + ") is not attached information.");
        }
        return receivedGoods.getAttachment();
    }

    public boolean receivedInformationEquals(InformationType type) {
        Goods receivedGoods = this.getReceivedGoods();
        if (!receivedGoods.hasAttachment()) {
            return false;
        }
        if (receivedGoods.getAttachmentKey() instanceof InformationType) {
            return receivedGoods.getAttachmentKey().equals(type);
        }
        return this.getWorld().getInformationType(receivedGoods.getAttachment()).equals(type);
    }

    public boolean receivedGoodsEquals(GoodsType type) {
        return this.getReceivedGoods().getType().equals(type);
    }

    public void firePrepareTimeEventReceive(UpdateBehaviorEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().prepareTimeEventReceive(e);
        }
    }

    public void fireTimeEventReceived(UpdateBehaviorEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().timeEventReceived(e);
        }
    }

    public void fireStateChanged(UpdateBehaviorEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().stateChanged(e);
        }
    }

    public void fireTransitionStarted(UpdateBehaviorEvent e) {
        if (this.getWorld().getPresentationContainer() != null) {
            this.getWorld().getPresentationContainer().getUpdateEventManager().transitionStarted(e);
        }
    }
}

