/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.GoodsQuantity;
import org.boxed_economy.besp.model.fmfw.GoodsType;

public class GoodsManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private HashMap goodsHashMap = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.GoodsManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected GoodsManager() {
    }

    public void addGoods(Goods goods) {
        logger.debug((Object)"IN");
        if (goods.getGoodsQuantity().getValueAsDouble() < 0.0) {
            logger.debug((Object)"OUT(Exception)");
            throw new ModelException("GoodsQuantity cannot be negative value.");
        }
        if (this.goodsHashMap.containsKey(goods.getType())) {
            Goods addGoods = (Goods)this.goodsHashMap.remove(goods.getType());
            this.goodsHashMap.put(addGoods.getType(), this.compositeGoods(addGoods, goods.getGoodsQuantity().getValueAsDouble()));
        } else {
            this.goodsHashMap.put(goods.getType(), goods);
        }
        logger.debug((Object)"OUT");
    }

    public Goods removeGoods(GoodsType type, double quantity) {
        logger.debug((Object)"IN");
        if (!this.goodsHashMap.containsKey(type)) {
            throw new ModelException("GoodsType is not found.");
        }
        if (((Goods)this.goodsHashMap.get(type)).getGoodsQuantity().getValueAsDouble() < quantity) {
            throw new ModelException("GoodsQuantity is not enough.");
        }
        Goods addGoods = (Goods)this.goodsHashMap.remove(type);
        if (this.separateGoods(addGoods, quantity).getGoodsQuantity().getValueAsDouble() > 0.0) {
            this.goodsHashMap.put(type, this.separateGoods(addGoods, quantity));
        }
        Goods newGoods = new Goods(type, quantity);
        newGoods.setWorld(addGoods.getWorld());
        newGoods.setInformations(new HashMap(addGoods.getInformations()));
        logger.debug((Object)"OUT");
        return newGoods;
    }

    public Goods removeAllGoods(GoodsType type) {
        logger.debug((Object)"IN");
        if (!this.goodsHashMap.containsKey(type)) {
            throw new ModelException("GoodsType is not found.");
        }
        Goods returnGoods = (Goods)this.goodsHashMap.get(type);
        this.goodsHashMap.remove(type);
        logger.debug((Object)"OUT");
        return returnGoods;
    }

    public GoodsQuantity getQuantity(GoodsType type) {
        logger.debug((Object)"IN");
        if (!this.goodsHashMap.containsKey(type)) {
            return new GoodsQuantity(0.0);
        }
        logger.debug((Object)"OUT");
        return new GoodsQuantity(((Goods)this.goodsHashMap.get(type)).getGoodsQuantity().getValueAsDouble());
    }

    public Collection getGoodsTypes() {
        return new HashSet(this.goodsHashMap.keySet());
    }

    public List removeGoodsRecursively(GoodsType type, double quantity) {
        logger.debug((Object)"IN");
        ArrayList<Goods> returnArray = new ArrayList<Goods>();
        List types = type.getChildrenRecursively();
        types.add(type);
        Iterator i = types.iterator();
        while (i.hasNext()) {
            GoodsType goodsType = (GoodsType)i.next();
            Goods g = this.removeGoods(goodsType, quantity);
            returnArray.add(g);
        }
        if (returnArray.isEmpty()) {
            throw new ModelException("Any GoodsType cannot found." + type);
        }
        logger.debug((Object)"OUT");
        return returnArray;
    }

    public Collection removeAllGoodsRecursively(GoodsType type) {
        logger.debug((Object)"IN");
        ArrayList<Goods> returnArray = new ArrayList<Goods>();
        Iterator i = type.getChildrenRecursively().iterator();
        while (i.hasNext()) {
            GoodsType t = (GoodsType)i.next();
            if (!this.goodsHashMap.containsKey(t)) continue;
            returnArray.add(this.removeAllGoods(t));
        }
        if (returnArray.isEmpty()) {
            throw new ModelException("Any GoodsType cannot found." + type);
        }
        logger.debug((Object)"OUT");
        return returnArray;
    }

    public GoodsQuantity getQuantityRecursively(GoodsType type) {
        logger.debug((Object)"IN");
        GoodsQuantity returnQuantity = new GoodsQuantity(0.0);
        if (this.goodsHashMap.containsKey(type)) {
            returnQuantity = returnQuantity.add(this.getQuantity(type));
        }
        Iterator i = type.getChildrenRecursively().iterator();
        while (i.hasNext()) {
            GoodsType goodsType = (GoodsType)i.next();
            returnQuantity = returnQuantity.add(this.getQuantity(goodsType));
        }
        logger.debug((Object)"OUT");
        return returnQuantity;
    }

    private Collection getGoodsCollectionRecursively(GoodsType type) {
        logger.debug((Object)"IN");
        Collection value = this.getGoodsCollection(type);
        Iterator i = type.getChildrenRecursively().iterator();
        while (i.hasNext()) {
            GoodsType t = (GoodsType)i.next();
            value.addAll(this.getGoodsCollection(t));
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    public Collection getGoodsCollection(GoodsType type) {
        logger.debug((Object)"IN");
        List value = (List)this.goodsHashMap.get(type);
        if (value == null || value.isEmpty()) {
            logger.debug((Object)"OUT");
            return new ArrayList();
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    private Collection removeAllGoodsCollection(GoodsType type) {
        logger.debug((Object)"IN");
        List value = (List)this.goodsHashMap.remove(type);
        if (value == null || value.isEmpty()) {
            throw new ModelException("Goods not found ! " + type);
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    private Goods compositeGoods(Goods goods, double addQuantity) {
        logger.debug((Object)"IN");
        double returnDouble = goods.getGoodsQuantity().getValueAsDouble() + addQuantity;
        Goods newGoods = new Goods(goods.getType(), returnDouble);
        newGoods.setWorld(goods.getWorld());
        newGoods.setInformations(new HashMap(goods.getInformations()));
        logger.debug((Object)"OUT");
        return newGoods;
    }

    private Goods separateGoods(Goods goods, double deleteQuantity) {
        logger.debug((Object)"IN");
        if (goods.getGoodsQuantity().getValueAsDouble() < deleteQuantity) {
            logger.debug((Object)"OUT(Exception)");
            throw new ModelException("GoodsQuantity cannot be negative value.");
        }
        double returnDouble = goods.getGoodsQuantity().getValueAsDouble() - deleteQuantity;
        Goods newGoods = new Goods(goods.getType(), returnDouble);
        newGoods.setWorld(goods.getWorld());
        newGoods.setInformations(new HashMap(goods.getInformations()));
        logger.debug((Object)"OUT");
        return newGoods;
    }
}

