/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Channel;
import org.boxed_economy.besp.model.fmfw.FmFwObject;
import org.boxed_economy.besp.model.fmfw.OpenChannelEvent;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationEvent;

public final class Relation
extends FmFwObject {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private RelationType type = null;
    private Agent source = null;
    private Agent target = null;
    private List channels = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.Relation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected Relation(RelationType type, Agent source, Agent target) {
        this.type = type;
        this.source = source;
        this.target = target;
    }

    public RelationType getType() {
        return this.type;
    }

    public Agent getSource() {
        return this.source;
    }

    public Agent getTarget() {
        return this.target;
    }

    public boolean openChannel(Behavior openBehavior, BehaviorType targetBehaviorType) {
        return this.openChannel(openBehavior, targetBehaviorType, false);
    }

    public boolean openChannel(Behavior openBehavior, BehaviorType targetBehaviorType, boolean keepChannel) {
        logger.debug((Object)"IN");
        OpenChannelEvent e = new OpenChannelEvent(this, targetBehaviorType);
        Behavior targetBehavior = this.target.receiveOpenChannelEvent(e);
        if (targetBehavior == null) {
            logger.debug((Object)"OUT(false)");
            return false;
        }
        Channel channel = new Channel(this, openBehavior, targetBehavior, keepChannel);
        openBehavior.setActiveChannel(channel);
        targetBehavior.setActiveChannel(channel);
        this.channels.add(channel);
        logger.debug((Object)"OUT(true)");
        this.fireChanneOpened(new UpdateRelationEvent(this, channel));
        return true;
    }

    protected void removeChannel(Channel channel) {
        logger.debug((Object)"IN");
        this.channels.remove(channel);
        this.fireChanneClosed(new UpdateRelationEvent(this, channel));
        logger.debug((Object)"OUT");
    }

    protected void fireChanneOpened(UpdateRelationEvent e) {
        if (this.source.getWorld().getPresentationContainer() != null) {
            this.source.getWorld().getPresentationContainer().getUpdateEventManager().channelOpened(e);
        }
    }

    protected void fireChanneClosed(UpdateRelationEvent e) {
        if (this.source.getWorld().getPresentationContainer() != null) {
            this.source.getWorld().getPresentationContainer().getUpdateEventManager().channelClosed(e);
        }
    }
}

