/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;

public class RelationManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private Agent owner;
    private HashMap relationHashMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.RelationManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    protected RelationManager(Agent agent) {
        this.owner = agent;
        this.relationHashMap = new HashMap();
    }

    public void addRelation(Relation relation) {
        logger.debug((Object)"IN");
        if (!relation.getSource().equals(this.owner)) {
            throw new ModelException("Relation\u306estart\u5143Agent\u304cRelationManager\u3092\u3082\u3064Agent\u3068\u4e00\u81f4\u3057\u3066\u3044\u307e\u305b\u3093" + relation);
        }
        ArrayList<Relation> list = (ArrayList<Relation>)this.relationHashMap.get(relation.getType());
        if (list != null) {
            if (list.contains(relation)) {
                list.remove(relation);
            }
            list.add(relation);
        } else {
            list = new ArrayList<Relation>();
            list.add(relation);
            this.relationHashMap.put(relation.getType(), list);
        }
        logger.debug((Object)"OUT");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeRelation(Relation relation) {
        logger.debug((Object)"IN");
        List list = (List)this.relationHashMap.get(relation.getType());
        if (list != null) {
            if (!list.contains(relation)) throw new ModelException("Relation not found ! " + relation);
            list.remove(relation);
            if (list == null || list.isEmpty()) {
                this.relationHashMap.remove(relation.getType());
            }
        } else {
            logger.debug((Object)"OUT(Exception)");
            throw new ModelException("Relation not found ! " + relation);
        }
        logger.debug((Object)"OUT");
    }

    public Collection removeRelations(RelationType type) {
        logger.debug((Object)"IN");
        List list = (List)this.relationHashMap.get(type);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                Relation relation = (Relation)i.next();
                i.remove();
                this.owner.fireRelationRemoved(new UpdateAgentEvent(this.owner, relation));
            }
        } else {
            logger.debug((Object)"OUT(Exception)");
            throw new ModelException("RelationType not found ! " + type);
        }
        this.relationHashMap.remove(type);
        logger.debug((Object)"OUT");
        return list;
    }

    public void removeRelationsByAgent(Agent agent) {
        logger.debug((Object)"IN");
        ArrayList list = new ArrayList();
        Iterator i = this.relationHashMap.keySet().iterator();
        while (i.hasNext()) {
            RelationType rType = (RelationType)i.next();
            list.addAll(this.getRelations(rType));
        }
        ArrayList<Relation> removeList = new ArrayList<Relation>();
        Iterator j = list.iterator();
        while (j.hasNext()) {
            Relation relation = (Relation)j.next();
            if (!agent.equals(relation.getTarget())) continue;
            removeList.add(relation);
        }
        Iterator k = removeList.iterator();
        while (k.hasNext()) {
            Relation relation = (Relation)k.next();
            this.removeRelation(relation);
            this.owner.fireRelationRemoved(new UpdateAgentEvent(this.owner, relation));
        }
        logger.debug((Object)"OUT");
    }

    public Collection removeRelationsRecursively(RelationType type) {
        logger.debug((Object)"IN");
        List value = (List)this.removeRelations(type);
        if (value != null) {
            Iterator i = type.getChildrenRecursively().iterator();
            while (i.hasNext()) {
                RelationType t = (RelationType)i.next();
                value.addAll(this.removeRelations(t));
            }
        } else {
            logger.debug((Object)"OUT(Exception)");
            throw new ModelException("RelationType not found ! " + type);
        }
        logger.debug((Object)"OUT");
        return value;
    }

    public Collection getRelationTypes() {
        return new HashSet(this.relationHashMap.keySet());
    }

    public Relation getRelation(RelationType type) {
        return (Relation)((List)this.getRelations(type)).get(0);
    }

    public Relation getRelation(RelationType type, Agent agent) {
        Relation returnRelation = null;
        Iterator ite = ((List)this.getRelations(type)).iterator();
        while (ite.hasNext()) {
            Relation relation = (Relation)ite.next();
            if (!relation.getTarget().equals(agent)) continue;
            returnRelation = relation;
        }
        if (returnRelation == null) {
            throw new ModelException("Not relation exists. " + this);
        }
        return returnRelation;
    }

    public Collection getRelations(RelationType type) {
        logger.debug((Object)"IN");
        List value = (List)this.relationHashMap.get(type);
        if (value == null || value.isEmpty()) {
            logger.debug((Object)"OUT(Exception)");
            return new ArrayList();
        }
        logger.debug((Object)"OUT");
        return new ArrayList(value);
    }

    public Collection getRelationsRecursively(RelationType type) {
        logger.debug((Object)"IN");
        List value = (List)this.getRelations(type);
        if (value != null) {
            Iterator i = type.getChildrenRecursively().iterator();
            while (i.hasNext()) {
                RelationType t = (RelationType)i.next();
                value.addAll(this.getRelations(t));
            }
            logger.debug((Object)"OUT");
            return new ArrayList(value);
        }
        logger.debug((Object)"OUT(Exception)");
        return new ArrayList();
    }

    public List getAllRelations() {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        Collection behaviorsLists = this.relationHashMap.values();
        Iterator i = behaviorsLists.iterator();
        while (i.hasNext()) {
            List relationsList = (List)i.next();
            Iterator j = relationsList.iterator();
            while (j.hasNext()) {
                Relation element = (Relation)j.next();
                relations.add(element);
            }
        }
        return relations;
    }
}

