/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentManager;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.DefaultRandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.FMFWConstants;
import org.boxed_economy.besp.model.fmfw.FmFwObject;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.RandomNumberGeneratorManager;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.Space;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldEvent;
import org.boxed_economy.besp.presentation.PresentationContainer;

public class World
extends FmFwObject {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private transient ModelContainer modelContainer = null;
    private Clock clock = null;
    private Space space = null;
    private boolean initialized = false;
    private long defaultRandomSeed = 0L;
    private long timeEventRandomSeed = 0L;
    private AgentManager agentManager = new AgentManager();
    private RandomNumberGeneratorManager randomManager = new RandomNumberGeneratorManager();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.World");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public final void initialize() {
        if (!this.initialized) {
            this.initializeWorld();
            this.initializeAgents();
            this.initialized = true;
        }
    }

    public void initializeWorld() {
        this.installRandomNumberGenerator(new DefaultRandomNumberGenerator("defaultRandom", this.defaultRandomSeed));
        this.installRandomNumberGenerator(new DefaultRandomNumberGenerator("timeEventRandom", this.timeEventRandomSeed));
    }

    public void initializeAgents() {
    }

    public String getName() {
        return this.getClass().getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public void setModelContainer(ModelContainer container) {
        this.modelContainer = container;
    }

    public PresentationContainer getPresentationContainer() {
        if (this.modelContainer == null) {
            return null;
        }
        return this.modelContainer.getPresentationContainer();
    }

    public ModelContainer getModelContainer() {
        return this.modelContainer;
    }

    public Agent getAgent(AgentType type) {
        return this.agentManager.getAgent(type);
    }

    public Collection getAgents(AgentType type) {
        return this.agentManager.getAgents(type);
    }

    public Collection getAgentsRecursively(AgentType type) {
        return this.agentManager.getAgentsRecursively(type);
    }

    public Collection getAllAgents() {
        return this.agentManager.getAllAgents();
    }

    public Agent createAgent() {
        return this.createAgent(FMFWConstants.AGENTTYPE_DEFAULT);
    }

    public Agent createAgent(AgentType type) {
        logger.debug((Object)"IN");
        Agent agent = new Agent(type);
        agent.setWorld(this);
        agent.initialize();
        this.agentManager.addAgent(agent);
        this.fireAgentCreated(new UpdateWorldEvent(this, agent));
        logger.debug((Object)"OUT");
        return agent;
    }

    public void destroyAgent(Agent agent) {
        logger.debug((Object)"IN");
        agent.receiveDeathEvent(agent);
        this.agentManager.removeAgent(agent);
        this.fireAgentDestroyed(new UpdateWorldEvent(this, agent));
        logger.debug((Object)"OUT");
    }

    public Goods createGoods(GoodsType type, double quantity) {
        logger.debug((Object)"IN");
        Goods goods = new Goods(type, quantity);
        goods.setWorld(this);
        this.fireGoodsCreated(new UpdateWorldEvent(this, goods));
        logger.debug((Object)"OUT");
        return goods;
    }

    public void consumeGoods(Goods goods) {
        this.fireGoodsConsumed(new UpdateWorldEvent(this, goods));
    }

    public void setClock(Clock clock) {
        this.clock = clock;
        clock.setWorld(this);
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public Space getSpace() {
        return this.space;
    }

    public RandomNumberGenerator getRandomNumberGenerator(String name) {
        return this.randomManager.getRandomNumberGenerator(name);
    }

    public RandomNumberGenerator getRandomNumberGenerator() {
        return this.randomManager.getRandomNumberGenerator("defaultRandom");
    }

    public void installRandomNumberGenerator(RandomNumberGenerator random) {
        this.randomManager.installRandomNumberGenerator(random);
    }

    public long getDefaultRandomSeed() {
        return this.defaultRandomSeed;
    }

    public void setDefaultRandomSeed(long defaultRandomSeed) {
        this.defaultRandomSeed = defaultRandomSeed;
    }

    public long getTimeEventRandomSeed() {
        return this.timeEventRandomSeed;
    }

    public void setTimeEventRandomSeed(long timeEventRandomSeed) {
        this.timeEventRandomSeed = timeEventRandomSeed;
    }

    public AgentType getAgentType(String key) {
        return this.modelContainer.getAgentType(key);
    }

    public BehaviorType getBehaviorType(String key) {
        return this.modelContainer.getBehaviorType(key);
    }

    public BehaviorType getBehaviorType(Behavior behavior) {
        return this.modelContainer.getBehaviorType(behavior.getClass().getName());
    }

    public GoodsType getGoodsType(String key) {
        return this.modelContainer.getGoodsType(key);
    }

    public InformationType getInformationType(String key) {
        return this.modelContainer.getInformationType(key);
    }

    public InformationType getInformationType(Information information) {
        return this.modelContainer.getInformationType(information.getClass().getName());
    }

    public RelationType getRelationType(String key) {
        return this.modelContainer.getRelationType(key);
    }

    public AgentType installAgentType(String name) {
        return this.modelContainer.installAgentType(name);
    }

    public AgentType installAgentType(String name, int priority) {
        return this.modelContainer.installAgentType(name, priority);
    }

    public GoodsType installGoodsType(String name) {
        return this.modelContainer.installGoodsType(name);
    }

    public BehaviorType installBehaviorType(String name) {
        return this.modelContainer.installBehaviorType(name);
    }

    public RelationType installRelationType(String name) {
        return this.modelContainer.installRelationType(name);
    }

    public InformationType installInformationType(String name) {
        return this.modelContainer.installInformationType(name);
    }

    public int getPriority(AgentType agentType) {
        return this.modelContainer.getPriority(agentType);
    }

    public void setPriority(AgentType agentType, int priority) {
        this.modelContainer.setPriority(agentType, priority);
    }

    protected void fireAgentCreated(UpdateWorldEvent e) {
        if (this.getPresentationContainer() != null) {
            this.getPresentationContainer().getUpdateEventManager().agentCreated(e);
        }
    }

    protected void fireAgentDestroyed(UpdateWorldEvent e) {
        if (this.getPresentationContainer() != null) {
            this.getPresentationContainer().getUpdateEventManager().agentDestroyed(e);
        }
    }

    protected void fireGoodsCreated(UpdateWorldEvent e) {
        if (this.getPresentationContainer() != null) {
            this.getPresentationContainer().getUpdateEventManager().goodsCreated(e);
        }
    }

    protected void fireGoodsConsumed(UpdateWorldEvent e) {
        if (this.getPresentationContainer() != null) {
            this.getPresentationContainer().getUpdateEventManager().goodsConsumed(e);
        }
    }
}

