/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.model.fmfw.behaviorimpl;

import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.model.fmfw.ChannelEvent;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultRootStateMachine;
import org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultStateElement;
import org.boxed_economy.besp.model.fmfw.behaviorimpl.DefaultTransition;

public class EventManager {
    private static final Logger logger;
    private LinkedList eventQueue = new LinkedList();
    private boolean isTransitioning = false;
    private DefaultRootStateMachine rootStateMachine = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.model.fmfw.behaviorimpl.EventManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public EventManager(DefaultRootStateMachine rootStateMachine) {
        this.rootStateMachine = rootStateMachine;
    }

    public boolean isReceivableEvent(Event e) {
        return this.rootStateMachine.getStateMachine().getReceivableTransition(e) != null;
    }

    public void receiveEvent(Event e) {
        if (BESP.DEBUG) {
            DefaultStateElement.traceEvent.info((Object)("receiveEvent < " + this.rootStateMachine.chopPackage(e.getClass().getName()) + " > in " + this.rootStateMachine.getPathAsString()));
        }
        if (e instanceof ChannelEvent) {
            this.rootStateMachine.getBehavior().setReceivedGoods((ChannelEvent)e);
        }
        if (this.isTransitioning) {
            this.enQueue(e);
            return;
        }
        this.isTransitioning = true;
        this.doTransition(e);
        this.isTransitioning = false;
        this.deliverEvents();
        this.autoTransition();
    }

    private void doTransition(Event e) {
        DefaultTransition transition = this.rootStateMachine.getStateMachine().getReceivableTransition(e);
        if (transition != null) {
            transition.doTransition();
            if (BESP.DEBUG) {
                DefaultStateElement.traceBehavior.info((Object)("transition completed to " + this.rootStateMachine.getCurrentStatePath()));
            }
        } else if (BESP.DEBUG) {
            DefaultStateElement.traceBehavior.info((Object)"event could not received");
        }
    }

    private void deliverEvents() {
        while (!this.eventQueue.isEmpty()) {
            this.rootStateMachine.receiveEvent(this.deQueue());
        }
    }

    private void autoTransition() {
        while (this.isReceivableEvent(DefaultStateElement.AUTO)) {
            this.rootStateMachine.receiveEvent(DefaultStateElement.AUTO);
        }
    }

    private void enQueue(Event e) {
        if (BESP.DEBUG) {
            DefaultStateElement.traceEvent.info((Object)("enQueue Event in " + this.rootStateMachine.getPathAsString()));
        }
        this.eventQueue.addLast(e);
        this.rootStateMachine.getBehavior().keepReceivedGoods();
    }

    private Event deQueue() {
        if (BESP.DEBUG) {
            DefaultStateElement.traceEvent.info((Object)("deQueue Event in " + this.rootStateMachine.getPathAsString()));
        }
        return (Event)this.eventQueue.removeFirst();
    }
}

