/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.SimulationStateEvent;
import org.boxed_economy.besp.model.SimulationStateListener;
import org.boxed_economy.besp.presentation.PresentationComponent;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.PresentationContainerListener;

public class PresentationComponentManager {
    private static final Logger logger;
    private PresentationContainer presentationContainer = null;
    private List presentationComponents = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.presentation.PresentationComponentManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public PresentationComponentManager(PresentationContainer container) {
        this.presentationContainer = container;
    }

    public void addPresentationComponent(PresentationComponent component) {
        if (!this.presentationComponents.contains(component)) {
            this.presentationComponents.add(component);
            this.initializePresentationComponent(component);
            logger.debug((Object)("PresentationComponent Added : " + component));
        }
    }

    public void removePresentationComponent(PresentationComponent component) {
        if (this.presentationComponents.contains(component)) {
            this.terminatePresentationComponent(component);
            this.presentationComponents.remove(component);
            logger.debug((Object)("PresentationComponent Removed : " + component));
        }
    }

    public List getPresentationComponents() {
        return new ArrayList(this.presentationComponents);
    }

    public PresentationComponent getPresentationComponent(Class presentationComponentClass) {
        Iterator i = this.presentationComponents.iterator();
        while (i.hasNext()) {
            PresentationComponent component = (PresentationComponent)i.next();
            if (!component.getClass().isAssignableFrom(presentationComponentClass)) continue;
            return component;
        }
        return null;
    }

    private void initializePresentationComponent(PresentationComponent component) {
        component.setPresentationContainer(this.presentationContainer);
        component.initialize();
        if (component instanceof PresentationContainerListener) {
            this.addPresentationContainerListener((PresentationContainerListener)((Object)component));
        }
        if (component instanceof ModelContainerListener) {
            this.addModelContainerListener((ModelContainerListener)((Object)component));
        }
        if (component instanceof SimulationStateListener) {
            this.addSimulationStateListener((SimulationStateListener)((Object)component));
        }
    }

    private void terminatePresentationComponent(PresentationComponent component) {
        if (component instanceof PresentationContainerListener) {
            this.removePresentationContainerListener((PresentationContainerListener)((Object)component));
        }
        if (component instanceof ModelContainerListener) {
            this.removeModelContainerListener((ModelContainerListener)((Object)component));
        }
        if (component instanceof SimulationStateListener) {
            this.removeSimulationStateListener((SimulationStateListener)((Object)component));
        }
        component.terminate();
    }

    private ModelContainer getModelContainer() {
        return this.presentationContainer.getModelContainer();
    }

    private void addModelContainerListener(ModelContainerListener l) {
        if (this.presentationContainer.getModelContainer().getModel() != null) {
            l.prepareWorldOpen(this.createModelContainerEvent());
            l.worldOpened(this.createModelContainerEvent());
        } else {
            l.prepareWorldClose(this.createModelContainerEvent());
            l.worldClosed(this.createModelContainerEvent());
        }
        this.presentationContainer.getModelContainer().addModelContainerListener(l);
    }

    private void removeModelContainerListener(ModelContainerListener l) {
        this.presentationContainer.getModelContainer().addModelContainerListener(l);
    }

    private void addPresentationContainerListener(PresentationContainerListener l) {
        this.presentationContainer.addPresentationContainerListener(l);
    }

    private void removePresentationContainerListener(PresentationContainerListener l) {
        this.presentationContainer.addPresentationContainerListener(l);
    }

    private void addSimulationStateListener(SimulationStateListener l) {
        if (this.getModelContainer().getModel() != null) {
            switch (this.getModelContainer().getModelThread().getState()) {
                case 3: {
                    l.simulationStarted(this.createSimulationStateEvent());
                    break;
                }
                case 2: {
                    l.simulationStopping(this.createSimulationStateEvent());
                    break;
                }
                case 1: {
                    l.simulationStopped(this.createSimulationStateEvent());
                    break;
                }
            }
        }
        this.getModelContainer().getModelThread().addSimulationStateListener(l);
    }

    private void removeSimulationStateListener(SimulationStateListener l) {
        this.getModelContainer().getModelThread().addSimulationStateListener(l);
    }

    private ModelContainerEvent createModelContainerEvent() {
        return new ModelContainerEvent(this.getModelContainer(), this.getModelContainer().getModel());
    }

    private SimulationStateEvent createSimulationStateEvent() {
        return new SimulationStateEvent(this.getModelContainer().getModelThread());
    }
}

