/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.ArgumentManager;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.presentation.PresentationComponent;
import org.boxed_economy.besp.presentation.PresentationComponentManager;
import org.boxed_economy.besp.presentation.PresentationContainerEvent;
import org.boxed_economy.besp.presentation.PresentationContainerListener;
import org.boxed_economy.besp.presentation.UpdateEventManager;
import org.boxed_economy.besp.presentation.bface.menu.MenuElement;
import org.boxed_economy.besp.presentation.guifw.ErrorDialog;
import org.boxed_economy.besp.presentation.guifw.GUIContainer;
import org.boxed_economy.besp.presentation.guifw.MainFrame;
import org.boxed_economy.besp.presentation.guifw.MenuManager;

public class PresentationContainer {
    private static final Logger logger;
    private BESPContainer container = null;
    private UpdateEventManager updateEventDeliverer = new UpdateEventManager();
    private PresentationComponentManager presentationComponentManager = new PresentationComponentManager(this);
    private GUIContainer guiContainer = null;
    private Vector presentationContainerListeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.presentation.PresentationContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        PresentationContainer.initializeLookAndFeel();
    }

    public static void initializeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(ArgumentManager.lookAndFeel);
        }
        catch (Exception ex) {
            logger.warn((Object)"invalid look and feel");
        }
    }

    public PresentationContainer(BESPContainer container) {
        this.container = container;
    }

    public void initialize() {
        this.addPresentationComponent(this.getGuiContainer());
    }

    public void terminate() {
        List presentationComponents = this.presentationComponentManager.getPresentationComponents();
        Collections.reverse(presentationComponents);
        Iterator i = presentationComponents.iterator();
        while (i.hasNext()) {
            PresentationComponent element = (PresentationComponent)i.next();
            this.presentationComponentManager.removePresentationComponent(element);
        }
    }

    public ModelContainer getModelContainer() {
        return this.getContainer().getModelContainer();
    }

    public BESPContainer getContainer() {
        return this.container;
    }

    public GUIContainer getGuiContainer() {
        if (this.guiContainer == null) {
            this.guiContainer = new GUIContainer();
        }
        return this.guiContainer;
    }

    public MainFrame getMainFrame() {
        return this.getGuiContainer().getMainFrame();
    }

    public MenuManager getMenuManager() {
        return this.getGuiContainer().getMenuManager();
    }

    public void addMenuElementToShowMenu(MenuElement element) {
        this.getGuiContainer().addMenuElementToShowMenu(element);
    }

    public void addMenuElementToToolsMenu(MenuElement element) {
        this.getGuiContainer().addMenuElementToToolsMenu(element);
    }

    public UpdateEventManager getUpdateEventManager() {
        return this.updateEventDeliverer;
    }

    public void addPresentationComponent(PresentationComponent component) {
        this.presentationComponentManager.addPresentationComponent(component);
        this.firePresentationComponentAdded(new PresentationContainerEvent(this, component));
        logger.info((Object)("PresentationComponent Added : " + component));
    }

    public void removePresentationComponent(PresentationComponent component) {
        this.presentationComponentManager.removePresentationComponent(component);
        this.firePresentationComponentRemoved(new PresentationContainerEvent(this, component));
        logger.info((Object)("PresentationComponent Removed : " + component));
    }

    public Collection getPresentationComponents() {
        return this.presentationComponentManager.getPresentationComponents();
    }

    public PresentationComponent getPresentationComponent(Class presentationComponentClass) {
        return this.presentationComponentManager.getPresentationComponent(presentationComponentClass);
    }

    public void showError(String message) {
        ErrorDialog.show(this.getMainFrame(), message);
    }

    public void showError(String message, Throwable th) {
        th.printStackTrace();
        logger.error((Object)message, th);
        ErrorDialog.show(this.getMainFrame(), message, th);
    }

    public void showTitle() {
        this.getGuiContainer().getSplashWindow().show();
    }

    public void hideTitle() {
        this.getGuiContainer().getSplashWindow().hide();
    }

    public void setInitialStatusMessage(String s) {
        this.getGuiContainer().getSplashWindow().setMessage(s);
    }

    public synchronized void addPresentationContainerListener(PresentationContainerListener l) {
        Vector v;
        Vector vector = v = this.presentationContainerListeners == null ? new Vector(2) : (Vector)this.presentationContainerListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.presentationContainerListeners = v;
        }
    }

    public synchronized void removePresentationContainerListener(PresentationContainerListener l) {
        if (this.presentationContainerListeners != null && this.presentationContainerListeners.contains(l)) {
            Vector v = (Vector)this.presentationContainerListeners.clone();
            v.removeElement(l);
            this.presentationContainerListeners = v;
        }
    }

    protected void firePresentationComponentAdded(PresentationContainerEvent e) {
        if (this.presentationContainerListeners != null) {
            Vector listeners = this.presentationContainerListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((PresentationContainerListener)listeners.elementAt(i)).presentationComponentAdded(e);
                ++i;
            }
        }
    }

    protected void firePresentationComponentRemoved(PresentationContainerEvent e) {
        if (this.presentationContainerListeners != null) {
            Vector listeners = this.presentationContainerListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((PresentationContainerListener)listeners.elementAt(i)).presentationComponentRemoved(e);
                ++i;
            }
        }
    }
}

