/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.bface;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.boxed_economy.besp.container.classtree.BoxClass;
import org.boxed_economy.besp.container.classtree.BoxClassTreeElement;
import org.boxed_economy.besp.container.classtree.BoxPackage;

public class ClassTreePanel
extends JPanel {
    private String classPath = "";
    private JScrollPane scrollPane = new JScrollPane();
    private JTree boxClassTree;
    private JTextField textFieldClassPath = new JTextField();
    private BorderLayout borderLayout = new BorderLayout();

    public ClassTreePanel() {
        this((BoxClassTreeElement)null);
    }

    public ClassTreePanel(BoxClassTreeElement rootElm) {
        this.setSize();
        this.createJTree(rootElm);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setVisible(true);
    }

    private void jbInit() throws Exception {
        this.boxClassTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ClassTreePanel.this.boxClassTree_valueChanged(e);
            }
        });
        this.setLayout(this.borderLayout);
        this.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add((Component)this.boxClassTree, null);
        this.add((Component)this.textFieldClassPath, "North");
    }

    private void setSize() {
        this.setPreferredSize(new Dimension(500, 500));
    }

    public void createJTree(BoxClassTreeElement rootElm) {
        if (rootElm == null) {
            BoxPackage defaultroot = new BoxPackage("NoRoot");
            defaultroot.add(new BoxClass("NoClass"));
            rootElm = defaultroot;
        }
        this.boxClassTree = new JTree(rootElm);
    }

    public String getClassPath() {
        return this.textFieldClassPath.getText();
    }

    void boxClassTree_valueChanged(TreeSelectionEvent e) {
        TreePath \u30d1\u30b9 = e.getPath();
        BoxClassTreeElement endElm = (BoxClassTreeElement)\u30d1\u30b9.getLastPathComponent();
        if (!(endElm instanceof BoxClass)) {
            return;
        }
        this.textFieldClassPath.setText(endElm.getAbsoluteName());
    }
}

