/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.bface;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.classtree.BoxClassTreeElement;
import org.boxed_economy.besp.container.classtree.BoxRootPackage;
import org.boxed_economy.besp.presentation.PresentationException;
import org.boxed_economy.besp.presentation.bface.BoxFileFilter;
import org.boxed_economy.besp.presentation.bface.ClassTreePanel;

public class GUIUtility {
    private static final Logger logger;
    private static JFileChooser fileChooser;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.presentation.bface.GUIUtility");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        fileChooser = null;
    }

    public static Image loadImage(String imageID, URL url) {
        if (url == null) {
            throw new PresentationException("invalid path in loadImage imageID= " + imageID);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return image;
    }

    public static Image loadImage(String imageID) {
        URL url = ClassLoader.getSystemClassLoader().getResource(imageID);
        return GUIUtility.loadImage(imageID, url);
    }

    public static Image loadImage(String imageID, Class clazz) {
        URL url = clazz.getResource(imageID);
        return GUIUtility.loadImage(imageID, url);
    }

    public static ImageIcon createIcon(String imageID) {
        Image image = GUIUtility.loadImage(imageID);
        return new ImageIcon(image);
    }

    public static ImageIcon createIcon(String imageID, Class clazz) {
        Image image = GUIUtility.loadImage(imageID, clazz);
        return new ImageIcon(image);
    }

    public static void setDefaultIcon(Component component) {
        block10: {
            try {
                if (component instanceof JInternalFrame) {
                    JInternalFrame jInternalFrame = (JInternalFrame)component;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.boxed_economy.besp.presentation.guifw.GUIContainer");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    jInternalFrame.setFrameIcon(GUIUtility.createIcon("image/boxicon.gif", clazz));
                    break block10;
                }
                if (!(component instanceof Frame)) break block10;
                Frame frame = (Frame)component;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.boxed_economy.besp.presentation.guifw.GUIContainer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                frame.setIconImage(GUIUtility.loadImage("image/boxicon.gif", clazz));
            }
            catch (Exception ex) {
                logger.warn((Object)"error in setDefaultIcon", (Throwable)ex);
            }
        }
    }

    public static void centerWindowWithPrefferedSize(Window window) {
        Window component = window;
        ((Component)component).setSize(((Component)component).getPreferredSize());
        GUIUtility.centerWindow(window);
    }

    public static void centerWindow(Window window) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension comp = window.getSize();
        window.setLocation((screen.width - comp.width) / 2, (screen.height - comp.height) / 2);
    }

    public static String showBoxClassTreeDialog(String windowTitle, Component settingComponent) {
        BoxRootPackage defaultroot = BESP.classTreeRoot;
        return GUIUtility.showBoxClassTreeDialog(defaultroot, windowTitle, settingComponent);
    }

    public static String showBoxClassTreeDialog(BoxClassTreeElement root, String windowTitle, Component settingComponent) {
        ClassTreePanel treePanel = new ClassTreePanel(root);
        int result = JOptionPane.showConfirmDialog(settingComponent, treePanel, windowTitle, 2, -1, null);
        if (result != 0) {
            return null;
        }
        return treePanel.getClassPath();
    }

    public static File chooseSaveFile(Component parent) {
        int result = GUIUtility.getFileChooser().showSaveDialog(parent);
        if (result != 0) {
            return null;
        }
        File choseFile = GUIUtility.getFileChooser().getSelectedFile();
        if (!choseFile.getName().endsWith(".box")) {
            choseFile = new File(String.valueOf(choseFile.getAbsolutePath()) + ".box");
        }
        return choseFile;
    }

    public static File chooseOpenFile(Component parent) {
        int result = GUIUtility.getFileChooser().showOpenDialog(parent);
        if (result != 0) {
            return null;
        }
        return GUIUtility.getFileChooser().getSelectedFile();
    }

    private static JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new BoxFileFilter());
            fileChooser.setCurrentDirectory(new File(BESP.boxHome));
        }
        return fileChooser;
    }
}

