/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.bface.menu;

import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.besp.presentation.bface.menu.ActionGroup;
import org.boxed_economy.besp.presentation.bface.menu.MenuElement;
import org.boxed_economy.besp.presentation.bface.menu.MenuElementGroup;
import org.boxed_economy.besp.presentation.bface.menu.MenuGroup;

public class Menu
extends MenuElementGroup {
    private JMenu jMenu = new JMenu();
    static /* synthetic */ Class class$0;

    public Menu() {
    }

    public Menu(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        super.setName(name);
        this.jMenu.setText(this.getName());
    }

    public JMenu getJMenu() {
        return this.jMenu;
    }

    public void setEnabled(boolean enabled) {
        this.getJMenu().setEnabled(enabled);
    }

    protected void refresh() {
        this.jMenu.removeAll();
        this.refreshGroup(this);
    }

    private void refreshGroup(MenuElementGroup group) {
        List elements = group.getElements();
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            MenuElement element = (MenuElement)i.next();
            if (element instanceof Action) {
                this.jMenu.add((Action)element);
                continue;
            }
            if (element instanceof Menu) {
                this.refreshMenu((Menu)element);
                continue;
            }
            if (element instanceof ActionGroup) {
                this.createSeparator();
                this.refreshGroup((ActionGroup)element);
                this.createSeparator();
                continue;
            }
            if (!(element instanceof MenuGroup)) continue;
            this.refreshGroup((MenuGroup)element);
        }
        this.trimSeparator();
    }

    private void refreshMenu(Menu menu) {
        this.jMenu.add(menu.getJMenu());
        menu.refresh();
    }

    private void createSeparator() {
        int itemCount = this.jMenu.getItemCount();
        if (itemCount != 0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.swing.JSeparator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(this.jMenu.getMenuComponent(itemCount - 1).getClass())) {
                this.jMenu.addSeparator();
            }
        }
    }

    private void trimSeparator() {
        int itemCount = this.jMenu.getItemCount();
        if (itemCount != 0) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("javax.swing.JSeparator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.isAssignableFrom(this.jMenu.getMenuComponent(itemCount - 1).getClass())) {
                this.jMenu.remove(this.jMenu.getItemCount() - 1);
            }
        }
    }
}

