/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.boxed_economy.besp.presentation.guifw.GUIContainer;

public class ErrorDialog
extends JPanel {
    public static final String TITLE = GUIContainer.resource.getString("Title_Error");
    public static final String DESCRIPTION = GUIContainer.resource.getString("Error_Description");
    public static final int STACKTRACEPANEL_WIDTH = 720;
    public static final int STACKTRACEPANEL_HEIGHT = 500;
    private Frame owner = null;
    private String message = null;
    private Throwable throwable = null;

    public static void show(Frame owner, String message) {
        JOptionPane.showMessageDialog(owner, message, TITLE, 0);
    }

    public static void show(Frame owner, String message, Throwable throwable) {
        JOptionPane.showMessageDialog(owner, new ErrorDialog(owner, message, throwable), TITLE, 0);
    }

    private ErrorDialog(Frame owner, String message, Throwable throwable) {
        this.owner = owner;
        this.message = message;
        this.throwable = throwable;
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel(this.message);
        this.add((Component)label, "North");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.add((Component)panel, "East");
        JButton button = this.createDescriptionButton();
        panel.add((Component)button, "South");
    }

    private JButton createDescriptionButton() {
        JButton button = new JButton(DESCRIPTION);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.showStackTraceDialog();
            }
        });
        return button;
    }

    private void showStackTraceDialog() {
        JOptionPane.showMessageDialog(this.owner, this.createStackTracePanel(), DESCRIPTION, -1);
    }

    private JPanel createStackTracePanel() {
        JPanel panel = new JPanel();
        JTextArea textArea = this.createStackTraceTextArea();
        final JScrollPane scroller = new JScrollPane(textArea);
        scroller.setPreferredSize(new Dimension(720, 500));
        panel.add((Component)scroller, null);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                scroller.getViewport().setViewPosition(new Point(0, 0));
            }
        });
        return panel;
    }

    private JTextArea createStackTraceTextArea() {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(outputStream);
        this.throwable.printStackTrace(printStream);
        JTextArea textArea = new JTextArea();
        textArea.setText(outputStream.toString());
        textArea.setEditable(false);
        return textArea;
    }
}

