/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.besp.presentation.guifw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.besp.presentation.bface.GUIUtility;
import org.boxed_economy.besp.presentation.guifw.GUIComponent;
import org.boxed_economy.besp.presentation.guifw.GUIContainer;

public class GUIComponentManagementDialog
extends JDialog {
    private static final Logger logger;
    private static final Color PANEL_COLOR;
    private static final int WIDTH = 500;
    private static final int HEIGHT = 400;
    private PresentationContainer presentationContainer = null;
    private ListItem[] guiComponents = null;
    private BorderLayout layout = new BorderLayout();
    private JPanel buttonPanel = new JPanel();
    private JScrollPane scrollPane = new JScrollPane();
    private JButton buttonAllSelect = new JButton();
    private JButton buttonClose = new JButton();
    private JButton buttonCancel = new JButton();
    private JButton buttonNoSelect = new JButton();
    private JPanel panel = new JPanel();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.besp.presentation.guifw.GUIComponentManagementDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        PANEL_COLOR = Color.white;
    }

    public GUIComponentManagementDialog(PresentationContainer presentationContainer, Frame parent) {
        super(parent, true);
        this.presentationContainer = presentationContainer;
        this.initializeComponents();
        this.initializeList();
        this.initializeDialog();
    }

    private void initializeDialog() {
        this.setTitle(GUIContainer.resource.getString("Title_AllClose"));
        this.setSize(500, 400);
        GUIUtility.centerWindow(this);
    }

    private void initializeComponents() {
        this.panel.setBackground(PANEL_COLOR);
        this.buttonAllSelect.setText(GUIContainer.resource.getString("Button_AllSelect"));
        this.buttonAllSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIComponentManagementDialog.this.selectAll(true);
            }
        });
        this.buttonNoSelect.setText(GUIContainer.resource.getString("Button_NoSelect"));
        this.buttonNoSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIComponentManagementDialog.this.selectAll(false);
            }
        });
        this.buttonClose.setText(GUIContainer.resource.getString("Button_Close"));
        this.buttonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIComponentManagementDialog.this.performClose();
                GUIComponentManagementDialog.this.exit();
            }
        });
        this.buttonCancel.setText(GUIContainer.resource.getString("Button_Cancel"));
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GUIComponentManagementDialog.this.exit();
            }
        });
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.buttonAllSelect, null);
        this.buttonPanel.add((Component)this.buttonNoSelect, null);
        this.buttonPanel.add((Component)this.buttonClose, null);
        this.buttonPanel.add((Component)this.buttonCancel, null);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add(this.panel);
    }

    private void initializeList() {
        this.panel.setLayout(null);
        Vector v = new Vector();
        Iterator compoIterator = this.presentationContainer.getPresentationComponents().iterator();
        while (compoIterator.hasNext()) {
            Object o = compoIterator.next();
            if (!(o instanceof GUIComponent)) continue;
            v.addElement(o);
        }
        Object[] GUIcomponentList = v.toArray();
        this.guiComponents = new ListItem[GUIcomponentList.length];
        int panelWidth = 100;
        int x = 20;
        int y = 0;
        int i = 0;
        while (i < this.guiComponents.length) {
            this.guiComponents[i] = new ListItem((GUIComponent)GUIcomponentList[i]);
            this.panel.add(this.guiComponents[i].checkBox);
            this.guiComponents[i].checkBox.setLocation(x, y);
            Dimension size = this.guiComponents[i].checkBox.getPreferredSize();
            this.guiComponents[i].checkBox.setSize(size);
            panelWidth = panelWidth > size.width ? panelWidth : size.width;
            y += size.height;
            ++i;
        }
        this.panel.setPreferredSize(new Dimension(panelWidth += 20, y));
        logger.debug((Object)("initializeList() end panel :x=" + panelWidth + "y=" + y));
    }

    private void selectAll(boolean b) {
        int len = this.guiComponents.length;
        int i = 0;
        while (i < len) {
            this.guiComponents[i].checkBox.setSelected(b);
            ++i;
        }
    }

    private void performClose() {
        int len = this.guiComponents.length;
        int i = 0;
        while (i < len) {
            if (this.guiComponents[i].checkBox.isSelected()) {
                this.guiComponents[i].component.close();
            }
            ++i;
        }
    }

    private void exit() {
        this.dispose();
    }

    class ListItem {
        private JCheckBox checkBox = null;
        private GUIComponent component = null;

        ListItem(GUIComponent component) {
            this.checkBox = new JCheckBox(component.toString());
            this.checkBox.setBackground(PANEL_COLOR);
            this.component = component;
        }
    }
}

