/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.boxlf5;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.lf5.viewer.LogTable;
import org.apache.log4j.lf5.viewer.TrackingAdjustmentListener;
import org.apache.log4j.lf5.viewer.categoryexplorer.CategoryExplorerTree;
import org.apache.log4j.lf5.viewer.configure.ConfigurationManager;
import org.apache.log4j.lf5.viewer.configure.MRUFileManager;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.boxlf5.BoxLF5InternalFrameComponent;

public class BoxLF5LogBrokerMonitor
extends LogBrokerMonitor {
    private PresentationContainer container = null;
    private BoxLF5InternalFrameComponent internalFrame;

    static {
        PresentationContainer.initializeLookAndFeel();
    }

    public BoxLF5LogBrokerMonitor(List logLevels) {
        super(logLevels);
    }

    public void setContainer(PresentationContainer container) {
        this.container = container;
    }

    public BoxLF5InternalFrameComponent createInternalFrameComponent() {
        BoxLF5InternalFrameComponent frame = new BoxLF5InternalFrameComponent();
        frame.setTitle("Log Window");
        return frame;
    }

    public void show(int delay) {
        this.internalFrame.show();
    }

    public void dispose() {
        this.hide();
    }

    protected void closeAfterConfirm() {
        this.hide();
    }

    public void hide() {
        this.internalFrame.hide();
    }

    public void setTitle(String title) {
        this.internalFrame.setTitle(String.valueOf(title) + " - LogFactor5");
    }

    protected void updateFrameSize() {
        this.internalFrame.setSize(this._logMonitorFrameWidth, this._logMonitorFrameHeight);
        this.centerFrame(this.internalFrame);
    }

    public BoxLF5InternalFrameComponent getInternalFrame() {
        return this.internalFrame;
    }

    public JFrame getBaseFrame() {
        if (this.container == null) {
            return null;
        }
        return this.container.getMainFrame();
    }

    protected void centerFrame(JInternalFrame frame) {
        if (this.getBaseFrame() != null) {
            Dimension screen = this.getBaseFrame().getSize();
            Dimension comp = frame.getSize();
            frame.setLocation((screen.width - comp.width) / 2, (screen.height - comp.height) / 2);
        }
    }

    protected void initComponents() {
        this._logMonitorFrame = new JFrame("LogFactor5");
        this.internalFrame = this.createInternalFrameComponent();
        this.internalFrame.setDefaultCloseOperation(0);
        this.updateFrameSize();
        JTextArea detailTA = this.createDetailTextArea();
        JScrollPane detailTAScrollPane = new JScrollPane(detailTA);
        this._table = new LogTable(detailTA);
        this.setView(this._currentView, this._table);
        this._table.setFont(new Font(this._fontName, 0, this._fontSize));
        this._logTableScrollPane = new JScrollPane((Component)this._table);
        if (this._trackTableScrollPane) {
            this._logTableScrollPane.getVerticalScrollBar().addAdjustmentListener((AdjustmentListener)new TrackingAdjustmentListener());
        }
        JSplitPane tableViewerSplitPane = new JSplitPane();
        tableViewerSplitPane.setOneTouchExpandable(true);
        tableViewerSplitPane.setOrientation(0);
        tableViewerSplitPane.setLeftComponent(this._logTableScrollPane);
        tableViewerSplitPane.setRightComponent(detailTAScrollPane);
        tableViewerSplitPane.setDividerLocation(350);
        this._categoryExplorerTree = new CategoryExplorerTree();
        this._table.getFilteredLogTableModel().setLogRecordFilter(this.createLogRecordFilter());
        JScrollPane categoryExplorerTreeScrollPane = new JScrollPane((Component)this._categoryExplorerTree);
        categoryExplorerTreeScrollPane.setPreferredSize(new Dimension(130, 400));
        this._mruFileManager = new MRUFileManager();
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setRightComponent(tableViewerSplitPane);
        splitPane.setLeftComponent(categoryExplorerTreeScrollPane);
        splitPane.setDividerLocation(130);
        this.internalFrame.getRootPane().setJMenuBar(this.createMenuBar());
        this.internalFrame.getContentPane().add((Component)splitPane, "Center");
        this.internalFrame.getContentPane().add((Component)this.createToolBar(), "North");
        this.internalFrame.getContentPane().add((Component)this.createStatusArea(), "South");
        this.makeLogTableListenToCategoryExplorer();
        this.addTableModelProperties();
        this._configurationManager = new ConfigurationManager((LogBrokerMonitor)this, this._table);
    }

    protected void updateMRUList() {
        JMenu menu = this.internalFrame.getJMenuBar().getMenu(0);
        menu.removeAll();
        menu.add(this.createOpenMI());
        menu.add(this.createOpenURLMI());
        menu.addSeparator();
        menu.add(this.createCloseMI());
        this.createMRUFileListMI(menu);
        menu.addSeparator();
        menu.add(this.createExitMI());
    }
}

