/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.cell;

import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.Information;

public class Cell
implements Information {
    private final int MAX_LOCATION = (int)Math.round(Math.sqrt(2.147483647E9));
    private int x;
    private int y;

    public Cell(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double measureDistance(Cell target) {
        if (Math.abs(this.x - target.x) + Math.abs(this.y - target.y) >= this.MAX_LOCATION) {
            throw new ModelException("DefaultLocation#getDistance int\u306e\u9650\u754c\u5024\u3092\u8d85\u3048\u308b\u305f\u3081\u300146341\u4ee5\u4e0a\u96e2\u308c\u3066\u3044\u308b\u30bb\u30eb\u306e\u8ddd\u96e2\u3092\u6e2c\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002");
        }
        double length = Math.sqrt(Math.pow(this.x - target.x, 2.0) + Math.pow(this.y - target.y, 2.0));
        return length;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Cell)) {
            return false;
        }
        Cell another = (Cell)o;
        return this.x == another.x && this.y == another.y;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + ")";
    }
}

