/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.cell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import org.boxed_economy.components.cell.CellSpace;

public abstract class CellFieldPanel
extends JPanel {
    private CellSpace cellSpace;
    private int cellSize = 10;
    private Color bgColor = Color.WHITE;
    private boolean writeBorder = true;
    private Color foreColor = Color.BLACK;
    private boolean isValidData = false;

    public final void drawField() {
        if (this.cellSpace == null || this.cellSpace.getXCellNum() < 1 || this.cellSpace.getYCellNum() < 1 || this.cellSize > 0) {
            this.isValidData = false;
        }
        this.isValidData = true;
        this.revalidate();
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        if (!this.isValidData) {
            this.setPreferredSize(new Dimension(100, 40));
            this.setBackground(Color.white);
            g.setColor(Color.red);
            g.drawString("Invalid Space", 20, 20);
            return;
        }
        this.setPreferredSize(new Dimension(this.cellSpace.getXCellNum() * this.cellSize, this.cellSpace.getYCellNum() * this.cellSize));
        this.drawBackGround(g);
        if (this.writeBorder) {
            this.drawBorder(g);
        }
        this.drawAgents(g);
        this.drawOthers(g);
    }

    protected void drawBackGround(Graphics g) {
        g.setColor(this.getBgColor());
        g.fillRect(0, 0, this.cellSpace.getYCellNum() * this.getCellSize(), this.cellSpace.getXCellNum() * this.getCellSize());
    }

    protected void drawBorder(Graphics g) {
        g.setColor(this.getForeColor());
        int i = 0;
        while (i <= this.cellSpace.getYCellNum()) {
            g.drawLine(0, i * this.getCellSize(), this.cellSpace.getYCellNum() * this.getCellSize(), i * this.getCellSize());
            ++i;
        }
        int j = 0;
        while (j <= this.cellSpace.getXCellNum()) {
            g.drawLine(j * this.getCellSize(), 0, j * this.getCellSize(), this.cellSpace.getXCellNum() * this.getCellSize());
            ++j;
        }
    }

    protected abstract void drawAgents(Graphics var1);

    protected void drawOthers(Graphics g) {
    }

    public void setCellSpace(CellSpace cellSpace) {
        this.cellSpace = cellSpace;
        this.drawField();
    }

    public CellSpace getCellSpace() {
        return this.cellSpace;
    }

    public int getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(int cellSize) {
        this.cellSize = cellSize;
        this.drawField();
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getForeColor() {
        return this.foreColor;
    }

    public void setBgColor(Color bgColor) {
        this.bgColor = bgColor;
        this.drawField();
    }

    public void setForeColor(Color foreColor) {
        this.foreColor = foreColor;
        this.drawField();
    }

    public boolean isWriteBorder() {
        return this.writeBorder;
    }

    public void setWriteBorder(boolean writeBorder) {
        this.writeBorder = writeBorder;
        this.drawField();
    }

    public boolean isValidData() {
        return this.isValidData;
    }

    public void setIsValidData(boolean isValidData) {
        this.isValidData = isValidData;
        this.drawField();
    }
}

