/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.commviewer;

import jp.ac.keio.sfc.crew.view.sgef.animation.CoverBlinkingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.animation.MovingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.animation.MovingAnimationThreadWithLine;
import jp.ac.keio.sfc.crew.view.sgef.animation.ShapeBlinkingAnimationThread;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SGraphicalRootEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.EGraphicalEditor;
import jp.ac.keio.sfc.crew.view.sgef.tools.SDragMoveTool;
import jp.ac.keio.sfc.crew.view.sgef.tools.SSelectionTool;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.commviewer.editparts.CommViewerEditPartFactory;
import org.boxed_economy.components.commviewer.editparts.CommunicationViewerRootEditPart;

public class CommunicationViewer {
    private EGraphicalEditor editor;
    private SGraphicalRootEditPart rootEditPart;
    private boolean animationEnable = true;
    private MovingAnimationThread goodsSendingThread = new MovingAnimationThread();
    private MovingAnimationThreadWithLine channelThread = new MovingAnimationThreadWithLine();
    private MovingAnimationThreadWithLine relationThread = new MovingAnimationThreadWithLine();
    private ShapeBlinkingAnimationThread blinkingThread = new ShapeBlinkingAnimationThread();
    private CoverBlinkingAnimationThread stateThread = new CoverBlinkingAnimationThread();
    private CoverBlinkingAnimationThread clockThread = new CoverBlinkingAnimationThread();

    public CommunicationViewer() {
        this.initializeThread();
    }

    public EGraphicalEditor getEditor() {
        if (this.editor == null) {
            this.editor = this.createEditor();
        }
        return this.editor;
    }

    private EGraphicalEditor createEditor() {
        EGraphicalEditor editor = new EGraphicalEditor();
        editor.setEditPartFactory(new CommViewerEditPartFactory("org.boxed_economy.components.commviewer.editparts"));
        this.rootEditPart = new CommunicationViewerRootEditPart();
        editor.setRootEditPart(this.rootEditPart);
        SSelectionTool selectiontool = new SSelectionTool(editor);
        selectiontool.setActive(true);
        SDragMoveTool movetool = new SDragMoveTool(editor);
        movetool.setActive(true);
        return editor;
    }

    protected void initializeThread() {
        this.goodsSendingThread.setInterval(20);
        this.goodsSendingThread.setStepCount(100);
        this.channelThread.setInterval(20);
        this.channelThread.setStepCount(20);
        this.relationThread.setInterval(20);
        this.relationThread.setStepCount(20);
        this.blinkingThread.setInterval(500);
        this.stateThread.setStepCount(3);
        this.stateThread.setInterval(500);
        this.clockThread.setStepCount(3);
        this.clockThread.setInterval(500);
    }

    public void setWorld(World world) {
        this.rootEditPart.setRootModel(world);
        this.rootEditPart.refresh();
        this.editor.validate();
    }

    public void stopAllThread() {
        this.blinkingThread.stopAndWait();
        this.goodsSendingThread.stopAndWait();
        this.channelThread.stopAndWait();
        this.stateThread.stopAndWait();
        this.clockThread.stopAndWait();
    }

    public ShapeBlinkingAnimationThread getBlinkingThread() {
        return this.blinkingThread;
    }

    public MovingAnimationThreadWithLine getChannelThread() {
        return this.channelThread;
    }

    public MovingAnimationThread getGoodsSendingThread() {
        return this.goodsSendingThread;
    }

    public CoverBlinkingAnimationThread getStateThread() {
        return this.stateThread;
    }

    public MovingAnimationThreadWithLine getRelationThread() {
        return this.relationThread;
    }

    public void setRelationThread(MovingAnimationThreadWithLine line) {
        this.relationThread = line;
    }

    public CoverBlinkingAnimationThread getClockThread() {
        return this.clockThread;
    }

    public boolean isAnimationEnable() {
        return this.animationEnable;
    }

    public void setAnimationEnable(boolean enable) {
        this.animationEnable = enable;
        if (this.animationEnable && !enable) {
            this.stopAllThread();
        }
    }
}

