/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.commviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import jp.ac.keio.sfc.crew.swing.ImageProvider;
import jp.ac.keio.sfc.crew.swing.SwingUtil;
import jp.ac.keio.sfc.crew.swing.visuals.BlowVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.LabelVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.LayerVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.animation.LinePath;
import jp.ac.keio.sfc.crew.view.sgef.animation.MovingAnimationThreadWithLine;
import jp.ac.keio.sfc.crew.view.sgef.editparts.SEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;
import jp.ac.keio.sfc.crew.view.sgef.ext.visuals.ELineConnectionVisualComponent;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.Channel;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.Relation;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateWorldListener;
import org.boxed_economy.besp.presentation.guifw.AbstractInternalFrameComponent;
import org.boxed_economy.components.commviewer.CommunicationViewer;
import org.boxed_economy.components.commviewer.CommunicationViewerPlugin;
import org.boxed_economy.components.commviewer.controller.MainSettingPanel;
import org.boxed_economy.components.commviewer.editparts.ChannelEditPart;
import org.boxed_economy.components.commviewer.editparts.CommunicationViewerRootEditPart;
import org.boxed_economy.components.commviewer.editparts.RelationEditPart;

public class CommunicationViewerFrame
extends AbstractInternalFrameComponent
implements ModelContainerListener,
UpdateWorldListener,
UpdateAgentListener,
UpdateBehaviorListener,
UpdateChannelListener,
UpdateRelationListener {
    private static final Logger logger;
    public static ResourceBundle resource;
    private CommunicationViewer commViewer;
    private MainSettingPanel controller;
    private boolean dirty = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.commviewer.CommunicationViewerFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        resource = CommunicationViewerPlugin.resource;
    }

    public void initialize() {
        this.initializeComponents();
        this.hookUpdateEvents();
    }

    private void initializeComponents() {
        Container container = this.getContentPane();
        JSplitPane split = new JSplitPane(1);
        split.setDividerLocation(600);
        container.add(split);
        this.commViewer = new CommunicationViewer();
        split.add(this.commViewer.getEditor());
        JScrollPane scroll = new JScrollPane();
        split.add(scroll);
        this.controller = new MainSettingPanel(this.commViewer);
        scroll.getViewport().add(this.controller);
        container.validate();
        container.repaint();
    }

    protected void initializeFrame() {
        this.setTitle(resource.getString("Name_Component"));
        this.setLocation(10, 10);
        this.setSize(800, 600);
    }

    public void terminate() {
        this.unhookUpdateEvents();
        this.commViewer.stopAllThread();
    }

    public void hookUpdateEvents() {
        this.addUpdateWorldListener(this);
        this.addUpdateAgentListener(this);
        this.addUpdateBehaviorListener(this);
        this.addUpdateChannelListener(this);
        this.addUpdateRelationListener(this);
    }

    public void unhookUpdateEvents() {
        this.removeUpdateWorldListener(this);
        this.removeUpdateAgentListener(this);
        this.removeUpdateBehaviorListener(this);
        this.removeUpdateChannelListener(this);
        this.removeUpdateRelationListener(this);
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
        World world = ev.getWorld();
        this.commViewer.setWorld(world);
        if (!this.isVisible()) {
            this.dirty = true;
        }
    }

    public void worldOpened(ModelContainerEvent ev) {
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
        this.commViewer.setWorld(null);
    }

    public void worldClosed(ModelContainerEvent ev) {
    }

    public void show() {
        super.show();
        if (this.dirty) {
            this.refreshAgentLocations();
            this.dirty = false;
        }
    }

    private void refreshAgentLocations() {
        Object object = this.getTreeLock();
        synchronized (object) {
            World world = this.getWorld();
            Iterator i = world.getAllAgents().iterator();
            while (i.hasNext()) {
                Agent agent = (Agent)i.next();
                this.adjustAgentLocation(world, agent);
            }
        }
    }

    public void agentCreated(UpdateWorldEvent e) {
        Object object = this.getTreeLock();
        synchronized (object) {
            World world = (World)e.getSource();
            Agent agent = (Agent)e.getObject();
            this.refresh(world);
            this.adjustAgentLocation(world, agent);
        }
    }

    private void adjustAgentLocation(World world, Agent agent) {
        VisualComponent agentVisual = this.getVisual(agent);
        VisualComponent worldVisual = this.getVisual(world);
        int hGap = 50;
        int vGap = 50;
        int wWidth = Math.max(worldVisual.getWidth(), 500);
        int wHeight = Math.max(worldVisual.getHeight(), 500);
        int aWidth = agentVisual.getWidth();
        int aHeight = agentVisual.getHeight();
        int vMargin = aWidth;
        int hMargin = aHeight;
        int y = vGap;
        while (y < wHeight) {
            int x = hGap;
            while (x < wWidth) {
                Component c = worldVisual.getComponentAt(x, y);
                if (c == worldVisual) {
                    agentVisual.setLocation(x, y);
                    this.commViewer.getEditor().getEditPart(agent).refreshVisualRecursively();
                    return;
                }
                x += aWidth + hMargin;
            }
            y += aHeight + vMargin;
        }
    }

    public void agentDestroyed(UpdateWorldEvent e) {
        World world = (World)e.getSource();
        this.refresh(world);
    }

    public void goodsConsumed(UpdateWorldEvent e) {
    }

    public void goodsCreated(UpdateWorldEvent e) {
    }

    public void behaviorAdded(UpdateAgentEvent e) {
        Agent agent = (Agent)e.getSource();
        this.refresh(agent);
    }

    public void behaviorRemoved(UpdateAgentEvent e) {
        Agent agent = (Agent)e.getSource();
        this.refresh(agent);
    }

    public void goodsAdded(UpdateAgentEvent e) {
    }

    public void goodsRemoved(UpdateAgentEvent e) {
    }

    public void informationAdded(UpdateAgentEvent e) {
    }

    public void informationRemoved(UpdateAgentEvent e) {
    }

    public void relationAdded(UpdateAgentEvent e) {
        Relation relation = (Relation)e.getObject();
        Agent agent = (Agent)e.getSource();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.refresh(agent);
            this.getVisual(relation).setVisible(false);
        }
        if (this.commViewer.isAnimationEnable()) {
            this.prepareMoveLineAnimation(this.commViewer.getRelationThread(), RelationEditPart.createRelationVisual(), agent, relation, false);
            this.commViewer.getRelationThread().startAndWait();
        }
        this.terminateAnimation();
        this.getVisual(relation).setVisible(true);
    }

    public void relationRemoved(UpdateAgentEvent e) {
        Relation relation = (Relation)e.getObject();
        Agent agent = (Agent)e.getSource();
        Agent targetAgent = relation.getTarget();
        this.getVisual(relation).setVisible(false);
        if (this.commViewer.isAnimationEnable()) {
            this.prepareMoveLineAnimation(this.commViewer.getRelationThread(), RelationEditPart.createRelationVisual(), agent, relation, true);
            this.commViewer.getRelationThread().startAndWait();
        }
        this.refresh(agent);
        this.refresh(targetAgent);
        this.terminateAnimation();
    }

    public void stateChanged(UpdateBehaviorEvent e) {
        Behavior behavior = (Behavior)e.getSource();
        this.refresh(behavior);
        if (this.commViewer.isAnimationEnable() && this.isStateVisible() && this.isBehaviorVisible()) {
            Color color = SwingUtil.createAlphaedColor(Color.RED, 100);
            this.commViewer.getStateThread().setColor(color);
            this.commViewer.getStateThread().setParent((EGraphicalEditPart)this.commViewer.getEditor().getEditPart(behavior));
            this.commViewer.getStateThread().startAndWait();
        }
    }

    public void transitionStarted(UpdateBehaviorEvent e) {
        Behavior behavior = (Behavior)e.getSource();
        this.refresh(behavior);
        if (this.commViewer.isAnimationEnable() && this.isStateVisible() && this.isBehaviorVisible()) {
            Color color = SwingUtil.createAlphaedColor(Color.RED, 100);
            this.commViewer.getStateThread().setColor(color);
            this.commViewer.getStateThread().setParent((EGraphicalEditPart)this.commViewer.getEditor().getEditPart(behavior));
            this.commViewer.getStateThread().startAndWait();
        }
    }

    public void prepareTimeEventReceive(UpdateBehaviorEvent e) {
        Behavior behavior = (Behavior)e.getSource();
        this.refresh(behavior);
        if (this.commViewer.isAnimationEnable() && this.isBehaviorVisible()) {
            Color color = SwingUtil.createAlphaedColor(Color.BLUE, 100);
            this.commViewer.getClockThread().setColor(color);
            this.commViewer.getClockThread().setParent((EGraphicalEditPart)this.commViewer.getEditor().getEditPart(behavior));
            this.commViewer.getClockThread().startAndWait();
        }
    }

    public void timeEventReceived(UpdateBehaviorEvent e) {
    }

    public void goodsReceive(UpdateChannelEvent e) {
    }

    public void goodsSent(UpdateChannelEvent e) {
        Channel channel = (Channel)e.getSource();
        Relation relation = channel.getParentRelation();
        Goods goods = e.getGoods();
        if (this.commViewer.isAnimationEnable()) {
            this.prepareBlinkingAnimation(channel);
            this.commViewer.getBlinkingThread().start();
            VisualComponent goodsVisual = this.createGoodsVisual(goods);
            boolean reverse = e.getSourceBehavior().getAgent() != relation.getSource();
            this.prepareMoveAnimation(goodsVisual, relation, reverse);
            this.commViewer.getGoodsSendingThread().startAndWait();
        }
        this.terminateAnimation();
    }

    public void channelClosed(UpdateRelationEvent e) {
        Relation relation = (Relation)e.getSource();
        Behavior behaviorA = e.getChannel().getBehaviorA();
        Behavior behaviorB = e.getChannel().getBehaviorB();
        Channel channel = e.getChannel();
        this.getVisual(channel).setVisible(false);
        if (this.commViewer.isAnimationEnable() && this.isBehaviorVisible()) {
            this.prepareBlinkingAnimation(relation);
            this.commViewer.getBlinkingThread().start();
            this.prepareMoveLineAnimation(this.commViewer.getChannelThread(), ChannelEditPart.createChannelVisual(), behaviorA, channel, true);
            this.commViewer.getChannelThread().startAndWait();
        }
        this.refresh(behaviorA);
        this.refresh(behaviorB);
        this.terminateAnimation();
    }

    public void channelOpened(UpdateRelationEvent e) {
        Relation relation = (Relation)e.getSource();
        Behavior behaviorA = e.getChannel().getBehaviorA();
        Behavior behaviorB = e.getChannel().getBehaviorB();
        Channel channel = e.getChannel();
        Object object = this.getTreeLock();
        synchronized (object) {
            this.refresh(behaviorA);
            this.refresh(behaviorB);
            this.getVisual(channel).setVisible(false);
        }
        if (this.commViewer.isAnimationEnable() && this.isBehaviorVisible()) {
            this.prepareBlinkingAnimation(relation);
            this.commViewer.getBlinkingThread().start();
            this.prepareMoveLineAnimation(this.commViewer.getChannelThread(), ChannelEditPart.createChannelVisual(), behaviorA, channel, false);
            this.commViewer.getChannelThread().startAndWait();
        }
        this.terminateAnimation();
        this.getVisual(channel).setVisible(true);
    }

    private boolean isStateVisible() {
        SEditPart root = this.commViewer.getEditor().getRootEditPart();
        if (root == null) {
            return false;
        }
        CommunicationViewerRootEditPart rootEditPart = (CommunicationViewerRootEditPart)root;
        return rootEditPart.isBehaviorStateVisible();
    }

    private boolean isBehaviorVisible() {
        return this.isVisible(CommunicationViewerRootEditPart.LAYER_BEHAVIOR_CONTAINERS);
    }

    private boolean isVisible(Object layerKey) {
        SEditPart root = this.commViewer.getEditor().getRootEditPart();
        if (root == null) {
            return false;
        }
        CommunicationViewerRootEditPart rootEditPart = (CommunicationViewerRootEditPart)root;
        LayerVisualComponent layer = rootEditPart.getLayer(layerKey);
        if (layer == null) {
            return false;
        }
        return layer.isVisible();
    }

    private VisualComponent createGoodsVisual(Goods goods) {
        if (goods.hasAttachment()) {
            return this.createBlowVisual(goods);
        }
        return this.createLabelVisual(goods);
    }

    private LabelVisualComponent createLabelVisual(Goods goods) {
        LabelVisualComponent label = new LabelVisualComponent();
        label.setText(goods.toString());
        Image image = ImageProvider.getInstance().getImage("org/boxed_economy/components/commviewer/visuals/goods.gif");
        label.setIcon(new ImageIcon(image));
        label.setLabelOpaque(true);
        label.setSizeToPreffered();
        return label;
    }

    private BlowVisualComponent createBlowVisual(Goods goods) {
        BlowVisualComponent blow = new BlowVisualComponent();
        blow.setText(goods.getAttachment().toString());
        blow.setSizeToPreffered();
        return blow;
    }

    private void prepareMoveAnimation(VisualComponent visual, Object pathModel, boolean reverse) {
        ELineConnectionVisualComponent pathConnection = (ELineConnectionVisualComponent)this.getVisual(pathModel);
        LinePath path = new LinePath(pathConnection.getLine());
        path.setReverse(reverse);
        visual.setLocationByCenter(path.getPoint(0));
        this.addAnimationVisual(visual);
        this.commViewer.getGoodsSendingThread().setVisual(visual);
        this.commViewer.getGoodsSendingThread().setPath(path);
    }

    private void prepareBlinkingAnimation(Object blinkingModel) {
        this.commViewer.getBlinkingThread().setVisual(this.getVisual(blinkingModel));
    }

    private void prepareMoveLineAnimation(MovingAnimationThreadWithLine thread, ELineConnectionVisualComponent dummyLine, Object sourceModel, Object pathModel, boolean reverse) {
        VisualComponent dummy = new VisualComponent();
        dummyLine.setSource(this.getVisual(sourceModel));
        dummyLine.setTarget(dummy);
        ELineConnectionVisualComponent channelLine = (ELineConnectionVisualComponent)this.getVisual(pathModel);
        LinePath path = new LinePath(channelLine.getLine());
        dummyLine.setConstraints(channelLine.getIndex(), channelLine.getCount());
        path.setReverse(reverse);
        this.addAnimationVisual(dummy);
        this.addAnimationVisual(dummyLine);
        thread.setVisual(dummy);
        thread.setPath(path);
        thread.setConnection(dummyLine);
    }

    public VisualComponent getVisual(Object model) {
        return this.commViewer.getEditor().getEditPart(model).getVisual();
    }

    public void refresh(Object model) {
        Object object = this.commViewer.getEditor().getTreeLock();
        synchronized (object) {
            this.commViewer.getEditor().getEditPart(model).refresh();
            this.commViewer.getEditor().getContentsLayer().validate();
            this.commViewer.getEditor().getContentsLayer().repaint();
        }
    }

    public void addAnimationVisual(VisualComponent visual) {
        Object object = this.commViewer.getEditor().getTreeLock();
        synchronized (object) {
            this.commViewer.getEditor().getAnimationLayer().add(visual);
            this.commViewer.getEditor().getAnimationLayer().validate();
        }
    }

    public void terminateAnimation() {
        this.commViewer.stopAllThread();
        Object object = this.commViewer.getEditor().getTreeLock();
        synchronized (object) {
            this.commViewer.getEditor().getAnimationLayer().removeAll();
            this.commViewer.getEditor().repaint();
        }
    }
}

