/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.commviewer.editparts;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import jp.ac.keio.sfc.crew.refrection.CClassUtil;
import jp.ac.keio.sfc.crew.swing.layout.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.visuals.PanelVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.RoundRectVisualComponent;
import jp.ac.keio.sfc.crew.swing.visuals.VisualComponent;
import jp.ac.keio.sfc.crew.view.sgef.ext.editparts.EGraphicalEditPart;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.components.commviewer.editparts.CommunicationViewerRootEditPart;

public class BehaviorEditPart
extends EGraphicalEditPart {
    public static final Font FONT = new Font("Comic Sans MS", 1, 14);
    private PanelVisualComponent panel = new PanelVisualComponent();
    private JLabel label = new JLabel();
    private VisualComponent statePanel = new RoundRectVisualComponent(15, 2.0f);
    private JLabel stateLabel = new JLabel();

    protected void activate() {
        super.activate();
        ((CommunicationViewerRootEditPart)this.getRoot()).addBehaviorEditPart(this);
    }

    protected void deactivate() {
        ((CommunicationViewerRootEditPart)this.getRoot()).removeBehaviorEditPart(this);
        super.deactivate();
    }

    protected Behavior getBehavior() {
        return (Behavior)this.getModel();
    }

    protected VisualComponent createVisual() {
        this.label.setFont(FONT);
        this.panel.setLayout(new VerticalFlowLayout(4));
        this.panel.add(this.label);
        this.panel.setBorder(BorderFactory.createLineBorder(Color.black, 2));
        this.panel.setBackground(new Color(230, 230, 230));
        this.panel.add(this.statePanel);
        this.statePanel.setLayout(new FlowLayout());
        this.statePanel.add(this.stateLabel);
        this.statePanel.setBackground(Color.WHITE);
        this.statePanel.setForeground(Color.BLACK);
        return this.panel;
    }

    protected List getModelUpperConnections() {
        return this.getBehavior().getAllChannels();
    }

    public void setStateVisible(boolean visible) {
        this.statePanel.setVisible(visible);
        this.refreshVisualRecursively();
    }

    public void refreshVisual() {
        this.label.setText(this.getBehaviorName());
        State state = this.getBehavior().getState();
        if (state != null) {
            this.stateLabel.setText(state.getName());
        } else {
            this.stateLabel.setText("State is null");
        }
        this.statePanel.setSize(this.statePanel.getPreferredSize());
        this.panel.setSize(this.panel.getPreferredSize());
        this.getParent().refreshVisual();
    }

    private String getBehaviorName() {
        return CClassUtil.getSimpleClassName(this.getBehavior().getType().getName());
    }
}

