/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.model.collectors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.boxed_economy.besp.model.fmfw.Goods;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.update.TradeEvent;
import org.boxed_economy.besp.model.fmfw.update.TradeListener;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.model.data.ColumnList;
import org.boxed_economy.components.datacollector.model.data.Record;
import org.boxed_economy.components.datacollector.model.fw.AbstractActiveDataCollector;

public class TradeDescriptionDataCollector
extends AbstractActiveDataCollector
implements TradeListener {
    public static final int MEASURE = 1;
    public static final int TARGET = 2;
    private String measureGoodsTypeName;
    private String targetGoodsTypeName;
    static /* synthetic */ Class class$0;

    public void initialize() {
        super.initialize();
        this.addTradeListener(this);
    }

    public void terminate() {
        super.terminate();
        this.removeTradeListener(this);
    }

    public void tradeCompleted(TradeEvent e) {
        if (!this.isValidState()) {
            return;
        }
        ArrayList allTransferedGoods = new ArrayList();
        allTransferedGoods.addAll(e.getGoodsFromChannelStart());
        allTransferedGoods.addAll(e.getGoodsFromChannelEnd());
        Goods measureGoods = this.searchGoods(allTransferedGoods, this.getMeasureGoodsType());
        Goods targetGoods = this.searchGoods(allTransferedGoods, this.getTargetGoodsType());
        if (measureGoods != null && targetGoods != null) {
            Record record = new Record(2);
            record.set(0, measureGoods.getGoodsQuantity().getValueAsDoubleObject());
            record.set(1, targetGoods.getGoodsQuantity().getValueAsDoubleObject());
            this.getDataTable().addRecord(record);
        }
    }

    private Goods searchGoods(Collection goodsList, GoodsType targetType) {
        Iterator i = goodsList.iterator();
        while (i.hasNext()) {
            Goods goods = (Goods)i.next();
            if (!goods.getType().equals(targetType)) continue;
            return goods;
        }
        return null;
    }

    public GoodsType getMeasureGoodsType() {
        return this.toType(this.measureGoodsTypeName);
    }

    public GoodsType getTargetGoodsType() {
        return this.toType(this.targetGoodsTypeName);
    }

    public GoodsType toType(String key) {
        GoodsType type = this.getDataCollection().getPresentationContainer().getModelContainer().getGoodsType(key);
        if (type == null) {
            return GoodsType.NULL;
        }
        return type;
    }

    private boolean isValidState() {
        return this.getMeasureGoodsType() != null && this.getTargetGoodsType() != null;
    }

    private void refreshColumns() {
        if (!this.isValidState()) {
            return;
        }
        ColumnList columns = new ColumnList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        columns.add(new Column(this.measureGoodsTypeName, clazz));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        columns.add(new Column(this.targetGoodsTypeName, clazz2));
        this.setColumns(columns);
    }

    public String getMeasureGoodsTypeName() {
        return this.measureGoodsTypeName;
    }

    public String getTargetGoodsTypeName() {
        return this.targetGoodsTypeName;
    }

    public void setMeasureGoodsTypeName(String type) {
        this.measureGoodsTypeName = type;
        this.refreshColumns();
    }

    public void setTargetGoodsTypeName(String type) {
        this.targetGoodsTypeName = type;
        this.refreshColumns();
    }
}

