/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.model.fw;

import org.boxed_economy.besp.model.ModelContainerEvent;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateStepListener;
import org.boxed_economy.besp.presentation.AbstractPresentationComponent;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.model.data.ColumnList;
import org.boxed_economy.components.datacollector.model.data.DataTable;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.model.fw.DataCollector;

public abstract class AbstractActiveDataCollector
extends AbstractPresentationComponent
implements DataCollector,
UpdateStepListener,
ModelContainerListener {
    private int stepInterval = 1;
    private transient int stepCount = 0;
    private ColumnList columns = new ColumnList();
    private DataCollection dataCollection = null;
    private transient DataTable dataTable = new DataTable();

    public void initialize() {
        this.addUpdateStepListener(this);
        this.initializeDataTable();
    }

    public void terminate() {
        this.removeUpdateStepListener(this);
    }

    public DataCollection getDataCollection() {
        return this.dataCollection;
    }

    public void setDataCollection(DataCollection collection) {
        this.dataCollection = collection;
    }

    public DataTable doCollection() {
        DataTable table = this.getDataTable();
        table.setColumns(this.columns);
        return table;
    }

    public ColumnList getColumns() {
        return this.columns;
    }

    protected void setColumns(ColumnList columns) {
        this.columns = columns;
    }

    protected void setSingleColumn(Column column) {
        ColumnList columns = new ColumnList();
        columns.add(column);
        this.columns = columns;
    }

    public DataTable getDataTable() {
        if (this.dataTable == null) {
            this.dataTable = new DataTable();
        }
        return this.dataTable;
    }

    public void setDataTable(DataTable table) {
        this.dataTable = table;
    }

    public String toString() {
        return "";
    }

    public int getStepInterval() {
        return this.stepInterval;
    }

    public void setStepInterval(int interval) {
        this.stepInterval = interval;
    }

    public void prepareStepStart(UpdateClockEvent e) {
        ++this.stepCount;
        if (this.stepCount == this.stepInterval) {
            this.initializeDataTable();
        }
    }

    private void initializeDataTable() {
        this.dataTable = new DataTable();
        this.stepCount = 0;
    }

    public void stepCompleted(UpdateClockEvent e) {
    }

    public void prepareWorldOpen(ModelContainerEvent ev) {
        this.initializeDataTable();
    }

    public void worldOpened(ModelContainerEvent ev) {
        this.initializeDataTable();
    }

    public void prepareWorldClose(ModelContainerEvent ev) {
    }

    public void worldClosed(ModelContainerEvent ev) {
    }
}

