/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.fw;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datacollector.model.fw.DataCollector;
import org.boxed_economy.components.datacollector.model.fw.DataCollectorDescriptor;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.fw.DataCollectorComposePanel;
import org.boxed_economy.components.datacollector.view.composer.fw.DataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.panels.DoubleDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.panels.MultipleDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.composer.panels.SingleDataSourceSelectionPanel;
import org.boxed_economy.components.datacollector.view.manager.AbstractDataCollectionManagementPanel;

public class DataCollectionComposeMainPanel
extends AbstractDataCollectionManagementPanel {
    private DataCollection dataCollection = null;
    private JTextField nameTextField = new JTextField();
    private JComboBox descriptorsComboBox = new JComboBox();
    private JPanel mainPanel = new JPanel();
    private JPanel sourceSelectionPanel = new JPanel();
    private JPanel collectorComposePanel = new JPanel();

    public void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.add(this.mainPanel);
        this.add(this.sourceSelectionPanel);
        this.add(this.collectorComposePanel);
        this.initializeMainPanel();
    }

    private void initializeMainPanel() {
        this.mainPanel.setLayout(new VerticalFlowLayout());
        this.nameTextField.setText(this.getDataCollection().getName());
        this.mainPanel.add(this.createResizedTitledPanel(DCResource.get("DataCollectionComposeMainPanel.Name"), this.nameTextField));
        this.initializeComboBoxForDataCollectionDescriptor(this.descriptorsComboBox);
        this.initializeDescriptorState();
        this.descriptorsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DataCollectionComposeMainPanel.this.setDataCollector();
            }
        });
        this.mainPanel.add(this.createResizedTitledPanel(DCResource.get("DataCollectionComposeMainPanel.CollectorType"), this.descriptorsComboBox));
    }

    private void initializeDescriptorState() {
        DataCollector collector = this.dataCollection.getCollector();
        if (collector == null) {
            this.descriptorsComboBox.setSelectedIndex(0);
            this.setDataCollector();
        } else {
            DataCollectorDescriptor descriptor = this.getManager().getDescriptor(collector);
            this.descriptorsComboBox.setSelectedItem(descriptor);
            this.dataCollectorChanged();
        }
    }

    public DataCollection getDataCollection() {
        return this.dataCollection;
    }

    public void setDataCollection(DataCollection collection) {
        this.dataCollection = collection;
    }

    private void setDataCollector() {
        DataCollectorDescriptor descriptor = (DataCollectorDescriptor)this.descriptorsComboBox.getSelectedItem();
        DataCollector collector = descriptor.createInstance();
        this.dataCollection.setCollector(collector);
        this.dataCollectorChanged();
    }

    private void dataCollectorChanged() {
        DataCollectorDescriptor descriptor = (DataCollectorDescriptor)this.descriptorsComboBox.getSelectedItem();
        this.updateSourceSelectionPanel(descriptor);
        this.updateCollectorEditPanel(descriptor);
        this.validate();
    }

    private void updateSourceSelectionPanel(DataCollectorDescriptor descriptor) {
        this.sourceSelectionPanel.removeAll();
        AbstractDataSourceSelectionPanel newSelectionPanel = null;
        switch (descriptor.getHavingSourceStrategy()) {
            case 2: {
                newSelectionPanel = new SingleDataSourceSelectionPanel();
                break;
            }
            case 4: {
                newSelectionPanel = new DoubleDataSourceSelectionPanel();
                break;
            }
            case 8: {
                newSelectionPanel = new MultipleDataSourceSelectionPanel();
                break;
            }
        }
        if (newSelectionPanel != null) {
            this.sourceSelectionPanel.add(newSelectionPanel);
            newSelectionPanel.setPresentationContainer(this.getPresentationContainer());
            newSelectionPanel.setParentEditPanel(this);
            newSelectionPanel.initialize();
            newSelectionPanel.setSelectedDataCollections(this.dataCollection.getSources());
            JLabel title = new JLabel(DCResource.get("DataCollectionComposeMainPanel.Source"));
            this.setPreferredSize(title, 100);
        }
    }

    private void updateCollectorEditPanel(DataCollectorDescriptor descriptor) {
        this.collectorComposePanel.removeAll();
        DataCollectorComposePanel panel = descriptor.createEditPanel();
        if (panel != null) {
            this.collectorComposePanel.add((JPanel)((Object)panel));
            panel.setPresentationContainer(this.getPresentationContainer());
            panel.setDataCollector(this.dataCollection.getCollector());
            panel.initialize();
        }
    }

    public void updateSource() {
        this.revalidateSource();
        DataCollectorComposePanel collectorEditPanel = this.getDataCollectorEditPanel();
        if (collectorEditPanel != null) {
            collectorEditPanel.sourceUpdated();
        }
    }

    private void revalidateSource() {
        DataSourceSelectionPanel sourceSelectionPanel = this.getDataSourceSelectionPanel();
        if (sourceSelectionPanel != null) {
            List selectedDataCollections = sourceSelectionPanel.getSelectedDataCollections();
            this.dataCollection.setSources(selectedDataCollections);
        }
    }

    private DataSourceSelectionPanel getDataSourceSelectionPanel() {
        if (this.sourceSelectionPanel.getComponentCount() != 0) {
            return (DataSourceSelectionPanel)((Object)this.sourceSelectionPanel.getComponent(0));
        }
        return null;
    }

    private DataCollectorComposePanel getDataCollectorEditPanel() {
        if (this.collectorComposePanel.getComponentCount() != 0) {
            return (DataCollectorComposePanel)((Object)this.collectorComposePanel.getComponent(0));
        }
        return null;
    }

    public void doOK() {
        this.dataCollection.setName(this.nameTextField.getText());
    }

    public void doCancel() {
    }
}

