/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.collectors.AbstractColumnSelectDataCollector;
import org.boxed_economy.components.datacollector.model.data.Column;
import org.boxed_economy.components.datacollector.view.composer.fw.AbstractDataCollectorComposePanel;

public class ColumnSelectDataCollectorComposePanel
extends AbstractDataCollectorComposePanel {
    private JComboBox comboBox = new JComboBox();

    public void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.sourceUpdated();
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ColumnSelectDataCollectorComposePanel.this.setColumn();
            }
        });
        JPanel titledColumnSelection = this.createResizedTitledPanel(DCResource.get("ColumnSelectDataCollectorComposePanel.Column"), this.comboBox);
        this.add(titledColumnSelection);
    }

    public void sourceUpdated() {
        this.refreshComboBox();
        this.setSelection();
        this.setColumn();
    }

    private void refreshComboBox() {
        if (this.getDataCollection().getSource() != null) {
            this.comboBox.removeAllItems();
            this.addItems(this.comboBox, this.getDataCollection().getSource().getColumns().getAsList());
        }
    }

    protected void setSelection() {
        Column col;
        String colName = this.getColumnSelectDataCollector().getColumnName();
        if (colName != null && (col = this.getDataCollection().getSource().getColumns().get(colName)) != null) {
            this.comboBox.setSelectedItem(col);
        }
    }

    protected void setColumn() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if (selectedItem instanceof Column) {
            Column column = (Column)selectedItem;
            this.getColumnSelectDataCollector().setColumnName(column.getName());
        }
    }

    protected AbstractColumnSelectDataCollector getColumnSelectDataCollector() {
        return (AbstractColumnSelectDataCollector)this.getDataCollector();
    }
}

