/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.panels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import jp.ac.keio.sfc.crew.refrection.ClassObject;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.argument.Argument;
import org.boxed_economy.components.datacollector.model.collectors.SelectByMethodDataCollector;
import org.boxed_economy.components.datacollector.view.composer.argumentwizard.SelectArgumentWizard;
import org.boxed_economy.components.datacollector.view.composer.panels.ColumnSelectDataCollectorComposePanel;

public class SelectByMethodDataCollectorComposePanel
extends ColumnSelectDataCollectorComposePanel
implements ItemListener {
    private JComboBox comboBox = new JComboBox();
    private JPanel argumentPanel = new JPanel();

    public void initialize() {
        super.initialize();
        this.comboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Method method = (Method)value;
                    StringBuffer signature = new StringBuffer();
                    signature.append(method.getName());
                    signature.append("(");
                    Class<?>[] types = method.getParameterTypes();
                    int i = 0;
                    while (i < types.length) {
                        if (i != 0) {
                            signature.append(", ");
                        }
                        signature.append(SelectByMethodDataCollectorComposePanel.this.getClassName(types[i]));
                        ++i;
                    }
                    signature.append(")");
                    this.setText(signature.toString());
                }
                return this;
            }
        });
        JPanel titledFieldSelection = this.createResizedTitledPanel(DCResource.get("SelectByMethodDataCollectorComposePanel.Method"), this.comboBox);
        this.add(titledFieldSelection);
        this.argumentPanel.setLayout(new VerticalFlowLayout(2));
        this.add(this.argumentPanel);
    }

    private String getClassName(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(".");
        if (index != -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    public void setColumn() {
        super.setColumn();
        this.comboBox.removeItemListener(this);
        this.initializeComboBox();
        this.initializeMethodSelection();
        this.refreshArguments();
        this.comboBox.addItemListener(this);
    }

    private void initializeComboBox() {
        if (this.getDataCollection().getSource() != null) {
            this.comboBox.removeAllItems();
            this.addItems(this.comboBox, this.getAllMethods());
        }
    }

    private void initializeMethodSelection() {
        Method method = this.getSelectByMethodDataCollector().getMethod();
        if (method != null) {
            this.comboBox.setSelectedItem(method);
        }
    }

    public List getAllMethods() {
        String colName = this.getSelectByMethodDataCollector().getColumnName();
        Class type = this.getDataCollection().getSource().getColumns().get(colName).getType();
        List methods = ClassObject.lookup(type).getMethods();
        return methods;
    }

    private void setMethod() {
        Object selectedItem = this.comboBox.getSelectedItem();
        if (selectedItem instanceof Method) {
            Method method = (Method)selectedItem;
            this.getSelectByMethodDataCollector().setMethod(method);
        }
        this.refreshArguments();
    }

    protected SelectByMethodDataCollector getSelectByMethodDataCollector() {
        return (SelectByMethodDataCollector)this.getDataCollector();
    }

    private void refreshArguments() {
        SelectByMethodDataCollector collector = this.getSelectByMethodDataCollector();
        List arguments = collector.getArguments();
        this.argumentPanel.removeAll();
        if (arguments.isEmpty()) {
            this.argumentPanel.add(new JLabel(DCResource.get("SelectByMethodDataCollectorComposePanel.No_Argument")));
        } else {
            int i = 0;
            while (i < arguments.size()) {
                final Argument arg = (Argument)arguments.get(i);
                JPanel panel = new JPanel();
                panel.add(new JLabel(String.valueOf(DCResource.get("SelectByMethodDataCollectorComposePanel.Argument")) + "[" + i + "] : "));
                panel.add(new JLabel(arg.toString()));
                JButton button = new JButton(DCResource.get("SelectByMethodDataCollectorComposePanel.Set"));
                button.setPreferredSize(new Dimension(50, 17));
                button.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        SelectByMethodDataCollectorComposePanel.this.showArgumentDialog(arg);
                    }
                });
                panel.add(button);
                this.argumentPanel.add(panel);
                ++i;
            }
        }
        this.revalidate();
    }

    private void showArgumentDialog(Argument argument) {
        SelectArgumentWizard wizard = new SelectArgumentWizard((Frame)this.getPresentationContainer().getMainFrame(), this.getDataCollection(), argument);
        wizard.show();
        this.refreshArguments();
    }

    public void itemStateChanged(ItemEvent e) {
        this.setMethod();
    }
}

