/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datacollector.view.composer.typechoosewizard;

import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.ac.keio.sfc.crew.swing.jface.list.ListPanel;
import jp.ac.keio.sfc.crew.swing.jface.wizard.WizardPage;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.components.datacollector.DCResource;
import org.boxed_economy.components.datacollector.model.argument.TypeType;
import org.boxed_economy.components.datacollector.model.collectors.TradeDescriptionDataCollector;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;

public class SelectGoodsTypeWizardPage
extends WizardPage {
    private DataCollection collection;
    private int typetype;
    private int rollType;
    private ListPanel listPanel = new ListPanel();

    public SelectGoodsTypeWizardPage(DataCollection collection, int typetype, int rollType) {
        this.collection = collection;
        this.typetype = typetype;
        this.rollType = rollType;
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.listPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                SelectGoodsTypeWizardPage.this.getWizard().refreshButtonState();
            }
        });
        this.listPanel.setList(TypeType.getTypes(this.collection.getPresentationContainer().getModelContainer(), this.typetype));
        this.listPanel.getJList().setSelectionMode(0);
        this.add(this.listPanel);
    }

    public WizardPage getNextWizardPage() {
        return null;
    }

    public boolean canGoNext() {
        return false;
    }

    public boolean canFinish() {
        return !this.listPanel.getSelectedElements().isEmpty();
    }

    public void finishPage() {
        GoodsType type = (GoodsType)this.listPanel.getSelectedElement();
        TradeDescriptionDataCollector collector = this.getTradeDescriptionDataCollector();
        if (this.rollType == 1) {
            collector.setMeasureGoodsTypeName(type.getName());
        } else if (this.rollType == 2) {
            collector.setTargetGoodsTypeName(type.getName());
        } else {
            throw new RuntimeException(DCResource.get("SelectGoodsTypeWizardPage.Illegal_RollType"));
        }
    }

    protected TradeDescriptionDataCollector getTradeDescriptionDataCollector() {
        return (TradeDescriptionDataCollector)this.collection.getCollector();
    }
}

