/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.jface.list.ElementChooser;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.datacollector.DataCollectionContainer;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.GraphComponent;

public class GraphComponentEditPanel
extends JPanel
implements DocumentListener {
    public static final int TEXT_HEIGHT = 20;
    private JFormattedTextField intervalTextField = new JFormattedTextField(new DecimalFormat());
    private PresentationContainer presentationContainer = null;
    private GraphComponent graphComponent = null;
    private List dataCollections = new ArrayList();
    private boolean updating = false;
    private JTextField nameTextField = new JTextField();
    private JLabel dataSourceLabel = new JLabel();
    private JFileChooser chooser = new JFileChooser(".");
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.initializeComponent();
        this.createContentsPanels();
    }

    private void initializeComponent() {
        this.setLayout(new VerticalFlowLayout());
    }

    private void createContentsPanels() {
        this.createNamePanel();
        this.createDataSourcePanel();
        this.createIntervalPanel();
    }

    private void createNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout(0));
        this.add(namePanel);
        JLabel nameTitleLabel = new JLabel(DPResource.get("GraphComponentEditPanel.Name"));
        namePanel.add(nameTitleLabel);
        this.nameTextField.setPreferredSize(new Dimension(300, 20));
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                GraphComponentEditPanel.this.updateModelFromView();
            }

            public void insertUpdate(DocumentEvent e) {
                GraphComponentEditPanel.this.updateModelFromView();
            }

            public void removeUpdate(DocumentEvent e) {
                GraphComponentEditPanel.this.updateModelFromView();
            }
        });
        namePanel.add(this.nameTextField);
    }

    private void createFileNamePanel(JPanel fileNamePanel, String title, JLabel nameLabel) {
        JPanel dataFileNamePanel = new JPanel();
        dataFileNamePanel.setLayout(new FlowLayout(0));
        fileNamePanel.add(dataFileNamePanel);
        JLabel fileNameTitleLabel = new JLabel(title);
        dataFileNamePanel.add(fileNameTitleLabel);
        dataFileNamePanel.add(nameLabel);
    }

    private void createDataSourcePanel() {
        JPanel dataSourcePanel = new JPanel();
        dataSourcePanel.setBorder(BorderFactory.createTitledBorder(DPResource.get("GraphComponentEditPanel.Data_Source")));
        dataSourcePanel.setLayout(new VerticalFlowLayout());
        this.add(dataSourcePanel);
        JLabel dataCollectionTitleLabel = new JLabel(DPResource.get("GraphComponentEditPanel.Data_Collection"));
        dataSourcePanel.add(dataCollectionTitleLabel);
        JPanel dataCollectionPanel = new JPanel();
        dataCollectionPanel.setLayout(new FlowLayout(0));
        dataSourcePanel.add(dataCollectionPanel);
        this.dataSourceLabel.setPreferredSize(new Dimension(400, 20));
        dataCollectionPanel.add(this.dataSourceLabel);
        JButton dataCollectionButton = new JButton(DPResource.get("GraphComponentEditPanel.Choose"));
        dataCollectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentEditPanel.this.doSelectDataCollection();
            }
        });
        dataCollectionPanel.add(dataCollectionButton);
    }

    private void createIntervalPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(DPResource.get("GraphComponentEditPanel.Data_Collection_Interval")));
        panel.setLayout(new VerticalFlowLayout());
        this.add(panel);
        this.intervalTextField.setPreferredSize(new Dimension(100, 20));
        panel.add(this.intervalTextField);
    }

    protected void doSelectDataCollection() {
        List selected = ElementChooser.open(this.getOwner(), this.getAllDataCollections(), this.getSelectedCollections(), DPResource.get("GraphComponentEditPanel.Choose_DataCollection"), DPResource.get("GraphComponentEditPanel.Choose_Single_DataCollection"), DPResource.get("GraphComponentEditPanel.DataCollection_List"), DPResource.get("GraphComponentEditPanel.Chosen_DataCollection"));
        if (selected != null && selected.size() > 0) {
            this.dataCollections = selected;
        }
        this.updateModelFromView();
    }

    public void updateViewFromModel() {
        if (this.graphComponent != null) {
            this.updating = true;
            this.nameTextField.setText(this.graphComponent.getName());
            this.dataCollections = this.graphComponent.getDataCollections();
            this.refreshDataCollectionLabel();
            this.intervalTextField.getDocument().removeDocumentListener(this);
            int interval = this.getGraphComponent().getStepInterval();
            this.intervalTextField.setText(Integer.toString(interval));
            this.intervalTextField.getDocument().addDocumentListener(this);
            this.updating = false;
        }
    }

    public void updateModelFromView() {
        if (!this.updating && this.graphComponent != null) {
            this.graphComponent.setName(this.nameTextField.getText());
            this.graphComponent.setDataCollections(new ArrayList(this.dataCollections));
        }
        this.refreshDataCollectionLabel();
    }

    private void refreshDataCollectionLabel() {
        if (this.graphComponent != null) {
            List dataCollections = this.graphComponent.getDataCollections();
            this.dataSourceLabel.setText(dataCollections.toString());
            return;
        }
        this.dataSourceLabel.setText(DPResource.get("GraphComponentEditPanel.No_Assignment"));
    }

    public boolean doOK() {
        if (this.graphComponent == null) {
            return false;
        }
        if (this.dataCollections == null) {
            return false;
        }
        this.updateModelFromView();
        return true;
    }

    public GraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public void setGraphComponent(GraphComponent component) {
        this.graphComponent = component;
        this.updateViewFromModel();
    }

    public PresentationContainer getPresentationContainer() {
        return this.presentationContainer;
    }

    public void setPresentationContainer(PresentationContainer container) {
        this.presentationContainer = container;
    }

    private List getSelectedCollections() {
        ArrayList list = new ArrayList();
        list.addAll(this.dataCollections);
        return list;
    }

    private List getAllDataCollections() {
        PresentationContainer presentationContainer = this.getPresentationContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.datacollector.DataCollectionContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataCollectionContainer dcContainer = (DataCollectionContainer)presentationContainer.getPresentationComponent(clazz);
        return dcContainer.getManager().getDataCollections();
    }

    private Frame getOwner() {
        Container comp = this;
        while (!(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.setInterval();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setInterval();
    }

    private void setInterval() {
        try {
            int newInterval = Integer.parseInt(this.intervalTextField.getText());
            this.getGraphComponent().setStepInterval(newInterval);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

