/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.jface.list.ListPanel;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.GraphComponent;
import org.boxed_economy.components.datapresentation.graph.GraphComponentEditPanel;
import org.boxed_economy.components.datapresentation.graph.GraphComponentManaer;
import org.boxed_economy.components.datapresentation.graph.legacy.viewer.MultiGraphGuiComponent;
import org.boxed_economy.components.datapresentation.graph.model.GraphModel;
import org.boxed_economy.components.datapresentation.graph.viewer.GraphGuiComponent;

public class GraphComponentManagementPanel
extends JPanel {
    private PresentationContainer presentationContainer = null;
    private ListPanel graphComponentsPanel = new ListPanel();
    private JPanel buttonsPanel = new JPanel();
    private JButton createButton = new JButton();
    private JButton editButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton activateButton = new JButton();
    private JButton deactivateButton = new JButton();
    private JButton showButton = new JButton();
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.initializeGraphComponentsPanel();
        this.initializeButtonsPanel();
        this.add((Component)this.buttonsPanel, "East");
        this.add((Component)this.graphComponentsPanel, "Center");
    }

    private void initializeGraphComponentsPanel() {
        this.graphComponentsPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GraphComponentManagementPanel.this.buttonStateUpdate();
            }
        });
        this.updateCollectionsPanel();
    }

    private void initializeButtonsPanel() {
        this.buttonsPanel.setLayout(new VerticalFlowLayout());
        this.createButton.setText(DPResource.get("GraphComponentManagementPanel.Create"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentManagementPanel.this.doCreate();
            }
        });
        this.buttonsPanel.add(this.createButton);
        this.editButton.setText(DPResource.get("GraphComponentManagementPanel.Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentManagementPanel.this.doEdit();
            }
        });
        this.buttonsPanel.add(this.editButton);
        this.activateButton.setText(DPResource.get("GraphComponentManagementPanel.Activate"));
        this.activateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentManagementPanel.this.doActive();
            }
        });
        this.buttonsPanel.add(this.activateButton);
        this.deactivateButton.setText(DPResource.get("GraphComponentManagementPanel.Deactivate"));
        this.deactivateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentManagementPanel.this.doDeactive();
            }
        });
        this.buttonsPanel.add(this.deactivateButton);
        this.removeButton.setText(DPResource.get("GraphComponentManagementPanel.Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentManagementPanel.this.doRemove();
            }
        });
        this.buttonsPanel.add(this.removeButton);
        this.showButton.setText(DPResource.get("GraphComponentManagementPanel.Show_Viewer"));
        this.showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphComponentManagementPanel.this.doShow();
            }
        });
        this.buttonsPanel.add(this.showButton);
        this.buttonStateUpdate();
    }

    private void buttonStateUpdate() {
        Object[] objects = this.graphComponentsPanel.getJList().getSelectedValues();
        if (objects.length > 0) {
            this.removeButton.setEnabled(true);
            this.activateButton.setEnabled(true);
            this.deactivateButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.activateButton.setEnabled(false);
            this.deactivateButton.setEnabled(false);
        }
        if (objects.length == 1) {
            this.editButton.setEnabled(true);
            this.showButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.showButton.setEnabled(false);
        }
    }

    private void doActive() {
        this.setActive(true);
    }

    private void doDeactive() {
        this.setActive(false);
    }

    private void doCreate() {
        this.createOpen();
        this.updateCollectionsPanel();
    }

    private void doEdit() {
        Object object = this.graphComponentsPanel.getJList().getSelectedValue();
        this.editOpen((GraphComponent)object);
        this.updateCollectionsPanel();
    }

    private void doRemove() {
        Object[] objects = this.graphComponentsPanel.getJList().getSelectedValues();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof GraphComponent) {
                this.getContainer().removeGraphComponent((GraphComponent)objects[i]);
            }
            ++i;
        }
        this.updateCollectionsPanel();
    }

    private void doShow() {
        GraphGuiComponent component = new GraphGuiComponent();
        this.presentationContainer.addPresentationComponent(component);
        Object object = this.graphComponentsPanel.getJList().getSelectedValue();
        GraphComponent gc = (GraphComponent)object;
        gc.setActive(true);
        this.updateCollectionsPanel();
        List graphModels = gc.getGraphModels();
        int i = 0;
        while (i < graphModels.size()) {
            GraphModel graphModel = (GraphModel)graphModels.get(i);
            component.getGraph().addData(graphModel);
            ++i;
        }
        component.update();
    }

    private void doLegacyShow() {
        MultiGraphGuiComponent component = new MultiGraphGuiComponent();
        this.presentationContainer.addPresentationComponent(component);
        Object object = this.graphComponentsPanel.getJList().getSelectedValue();
        GraphComponent gc = (GraphComponent)object;
        gc.setActive(true);
        this.updateCollectionsPanel();
        List graphModels = gc.getGraphModels();
        int i = 0;
        while (i < graphModels.size()) {
            GraphModel graphModel = (GraphModel)graphModels.get(i);
            component.getView().addGraphModel(graphModel);
            ++i;
        }
    }

    private void setActive(boolean active) {
        Object[] objects = this.graphComponentsPanel.getJList().getSelectedValues();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof GraphComponent) {
                ((GraphComponent)objects[i]).setActive(active);
            }
            ++i;
        }
        this.updateCollectionsPanel();
    }

    private void updateCollectionsPanel() {
        this.graphComponentsPanel.setList(this.getContainer().getGraphComponents());
    }

    public GraphComponentManaer getContainer() {
        PresentationContainer presentationContainer = this.getPresentationContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.datapresentation.graph.GraphComponentManaer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (GraphComponentManaer)presentationContainer.getPresentationComponent(clazz);
    }

    public PresentationContainer getPresentationContainer() {
        return this.presentationContainer;
    }

    public void setPresentationContainer(PresentationContainer container) {
        this.presentationContainer = container;
    }

    public void createOpen() {
        GraphComponent graphComponent = new GraphComponent();
        graphComponent.setName("New Graph");
        int result = this.editOpen(graphComponent);
        if (result == 0) {
            this.getContainer().addGraphComponent(graphComponent);
        }
    }

    public int editOpen(GraphComponent graphComponent) {
        GraphComponentEditPanel editor = new GraphComponentEditPanel();
        editor.setGraphComponent(graphComponent);
        editor.setPresentationContainer(this.getPresentationContainer());
        editor.initialize();
        int result = JOptionPane.showConfirmDialog(this.presentationContainer.getMainFrame(), editor, DPResource.get("GraphComponentManagementPanel.Graph_Component_Editor"), 0, -1, null);
        if (result == 0 && editor.doOK()) {
            return result;
        }
        return 2;
    }
}

