/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.boxed_economy.components.datapresentation.graph.model.PointList;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GDataSet;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class GraphCanvas
extends JPanel {
    private GGraphContainer container;

    public GraphCanvas() {
        this.setBackground(Color.white);
    }

    public void setContainer(GGraphContainer container) {
        this.container = container;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawGrids(g);
        this.drawDataSet(g);
    }

    private void drawDataSet(Graphics g) {
        List dataSet = this.container.getGraph().getDataSets();
        Iterator i = dataSet.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            this.drawData(g, data);
        }
    }

    private void drawData(Graphics g, GDataSet data) {
        Color oldColor = g.getColor();
        g.setColor(data.getColor());
        PointList points = data.getScaledPoints();
        Point2D.Double previous = null;
        Point2D.Double current = null;
        Iterator i = points.iterator();
        while (i.hasNext()) {
            current = (Point2D.Double)i.next();
            if (previous != null) {
                this.drawLine(g, previous, current);
            }
            previous = current;
        }
        g.setColor(oldColor);
    }

    private void drawLine(Graphics g, Point2D.Double p1, Point2D.Double p2) {
        p1 = this.translateForCanvas(p1);
        p2 = this.translateForCanvas(p2);
        g.drawLine((int)p1.x, (int)p1.y, (int)p2.x, (int)p2.y);
    }

    private Point2D.Double translateForCanvas(Point2D.Double p) {
        Point2D.Double origin = this.container.getOrigin();
        Point2D.Double translated = new Point2D.Double(p.x, p.y);
        translated.x += origin.x;
        translated.y = origin.y - p.y;
        return translated;
    }

    private void drawGrids(Graphics g) {
        List axisListY;
        Color oldColor = g.getColor();
        g.setColor(Color.GRAY);
        List axisListX = this.container.getGraph().getAxisListX();
        if (!axisListX.isEmpty() && this.container.getGraph().isShowGridX()) {
            this.drawGridX(g, (GAxis)axisListX.get(0));
        }
        if (!(axisListY = this.container.getGraph().getAxisListY()).isEmpty() && this.container.getGraph().isShowGridY()) {
            this.drawGridY(g, (GAxis)axisListY.get(0));
        }
        g.setColor(oldColor);
    }

    public void drawGridX(Graphics g, GAxis axis) {
        double scale;
        Point2D.Double origin = this.container.getOrigin();
        int rightSide = this.getWidth();
        boolean leftSide = false;
        double step = axis.getMeasure().getStep();
        double measure = step * (scale = axis.getScale().getValue());
        if (measure < 1.0) {
            return;
        }
        int i = 0;
        while (measure * (double)i + origin.x < (double)rightSide) {
            this.drawGridX(g, origin, step, scale, measure, i);
            ++i;
        }
        i = 0;
        while (measure * (double)i + origin.x > (double)leftSide) {
            this.drawGridX(g, origin, step, scale, measure, i);
            --i;
        }
    }

    private void drawGridX(Graphics g, Point2D.Double origin, double step, double scale, double measure, int i) {
        int x = (int)(measure * (double)i) + (int)origin.x;
        if (i % 5 == 0) {
            if (i == 0) {
                this.setPenWidth(g, 2);
                g.drawLine(x, 0, x, this.getHeight());
                this.setPenWidth(g, 1);
            } else {
                g.drawLine(x, 0, x, this.getHeight());
            }
        }
    }

    public void drawGridY(Graphics g, GAxis axis) {
        double scale;
        Point2D.Double origin = this.container.getOrigin();
        boolean top = false;
        int bottom = this.getHeight();
        double step = axis.getMeasure().getStep();
        double measure = step * (scale = axis.getScale().getValue());
        if (measure < 1.0) {
            return;
        }
        int i = 0;
        while (-(measure * (double)i) + origin.y > (double)top) {
            this.drawGridY(g, origin, step, scale, measure, i);
            ++i;
        }
        i = 0;
        while (-(measure * (double)i) + origin.y < (double)bottom) {
            this.drawGridY(g, origin, step, scale, measure, i);
            --i;
        }
    }

    private void drawGridY(Graphics g, Point2D.Double origin, double step, double scale, double measure, int i) {
        int y = -((int)(measure * (double)i)) + (int)origin.y;
        if (i % 5 == 0) {
            if (i == 0) {
                this.setPenWidth(g, 2);
                g.drawLine(0, y, this.getWidth(), y);
                this.setPenWidth(g, 1);
            }
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    private void setPenWidth(Graphics g, int width) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(width));
        }
    }
}

