/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.viewer.dialogs.DataSettingDialogPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GDataSet;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class GraphDataListPanel
extends JPanel {
    private GGraphContainer container;
    private JList list = new JList();
    private JButton button = new JButton(DPResource.get("GraphDataListPanel.Setting"));

    public GraphDataListPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.list.setSelectionBackground(Color.white);
        this.list.setCellRenderer(new DataListCellRenderer());
        this.list.setBackground(Color.white);
        JScrollPane scrollpane = new JScrollPane();
        scrollpane.setViewportView(this.list);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GraphDataListPanel.this.showDialog();
            }
        });
        this.add((Component)scrollpane, "Center");
        this.add((Component)this.button, "South");
    }

    public void setContainer(GGraphContainer container) {
        this.container = container;
        this.update();
    }

    public void update() {
        this.list.setListData(this.container.getGraph().getDataSets().toArray());
        this.validateTree();
        this.repaint();
    }

    private void showDialog() {
        DataSettingDialogPanel panel = new DataSettingDialogPanel(this.container);
        JOptionPane.showConfirmDialog(null, panel, DPResource.get("GraphDataListPanel.Data_Setting"), 2, -1, null);
    }

    class DataListCellRenderer
    implements ListCellRenderer {
        DataListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GDataSet data = (GDataSet)value;
            BufferedImage buf = new BufferedImage(30, 30, 6);
            Graphics2D g = buf.createGraphics();
            g.setColor(data.getColor());
            g.drawLine(5, 15, 25, 15);
            g.dispose();
            JLabel label = new JLabel();
            label.setIcon(new ImageIcon(buf));
            label.setText(data.getModel().getLabel());
            return label;
        }
    }
}

