/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.axis;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.viewer.dialogs.AxisSettingDialogPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public abstract class AbstractAxisDescriptionPanel
extends JComponent {
    private GGraphContainer container;
    private GAxis axis;
    protected JButton zoomInButton = new JButton(DPResource.get("AbstractAxisDescriptionPanel.Zoom_In_Button"));
    protected JButton zoomOutButton = new JButton(DPResource.get("AbstractAxisDescriptionPanel.Zoom_Out_Button"));
    protected JButton openDialogButton = new JButton(DPResource.get("AbstractAxisDescriptionPanel.Open_Axis_Button"));
    protected JPanel buttonsPanel = new JPanel();

    public AbstractAxisDescriptionPanel(GGraphContainer container, GAxis axis) {
        this.axis = axis;
        this.container = container;
        this.initialize();
    }

    private void initialize() {
        this.initializeButtonsPanel();
        this.initializeComponent();
    }

    private void initializeButtonsPanel() {
        this.openDialogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractAxisDescriptionPanel.this.openDialog();
            }
        });
        this.zoomInButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractAxisDescriptionPanel.this.zoom(2.0);
            }
        });
        this.zoomOutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractAxisDescriptionPanel.this.zoom(0.5);
            }
        });
        this.resizeButton(this.openDialogButton);
        this.resizeButton(this.zoomInButton);
        this.resizeButton(this.zoomOutButton);
        this.buttonsPanel.setLayout(this.createButtonPanelLayout());
        this.buttonsPanel.add(this.zoomInButton);
        this.buttonsPanel.add(this.openDialogButton);
        this.buttonsPanel.add(this.zoomOutButton);
    }

    private void resizeButton(JButton button) {
        Dimension d = new Dimension();
        d.width = 30;
        d.height = 30;
        button.setPreferredSize(d);
        button.setMargin(new Insets(3, 3, 3, 3));
    }

    protected abstract void initializeComponent();

    protected abstract LayoutManager createButtonPanelLayout();

    private void zoom(double power) {
        this.axis.getScale().zoom(power);
        this.container.update();
    }

    private void openDialog() {
        AxisSettingDialogPanel panel = new AxisSettingDialogPanel(this.container, this.axis);
        JOptionPane.showMessageDialog(null, panel, DPResource.get("AbstractAxisDescriptionPanel.Axis_Setting"), -1);
        panel.apply();
    }

    public GAxis getAxis() {
        return this.axis;
    }

    public GGraphContainer getContainer() {
        return this.container;
    }
}

