/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.dialogs;

import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GDataSet;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public abstract class AbstractDataDependentSettingPanel
extends JPanel
implements ItemListener {
    private GGraphContainer container;
    private GDataSet data;
    private JCheckBox checkbox = new JCheckBox();
    private JComboBox combobox = new JComboBox();

    public AbstractDataDependentSettingPanel(GGraphContainer container, GDataSet data) {
        this.container = container;
        this.data = data;
        this.initialize();
    }

    private void initialize() {
        this.initializeComboBox();
        this.add(this.checkbox);
        this.add(this.combobox);
        this.initializeData();
        this.hook();
    }

    private void initializeComboBox() {
        Iterator i = this.container.getGraph().getDataSets().iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            this.combobox.addItem(data);
        }
    }

    void hook() {
        this.checkbox.addItemListener(this);
        this.combobox.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        this.update();
        this.updated();
    }

    private void initializeData() {
        this.checkbox.setSelected(this.isDependent());
        this.combobox.setEnabled(this.isDependent());
        this.combobox.setSelectedItem(this.getDependent());
    }

    public void update() {
        this.combobox.setBackground(Color.WHITE);
        this.combobox.setEnabled(this.checkbox.isSelected());
        GDataSet newDependent = null;
        if (this.checkbox.isSelected()) {
            GDataSet selectedData = (GDataSet)this.combobox.getSelectedItem();
            if (selectedData != null && this.getDependentList(selectedData).contains(this.data)) {
                this.combobox.setBackground(Color.RED);
            } else {
                newDependent = selectedData;
            }
        }
        this.setDependent(newDependent);
    }

    public GDataSet getData() {
        return this.data;
    }

    public abstract List getDependentList(GDataSet var1);

    public abstract void setDependent(GDataSet var1);

    public abstract void updated();

    public abstract GDataSet getDependent();

    public abstract boolean isDependent();
}

