/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.dialogs;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.boxed_economy.components.datapresentation.DPResource;

public abstract class AbstractDoubleValueSettingPanel
extends JPanel {
    private static NumberFormatter FORMATTER = new NumberFormatter(new DecimalFormat("0.##"));
    private JLabel manualLabel = new JLabel(DPResource.get("AbstractDoubleValueSettingPanel.Manual"));
    private JTextField valueTextfield = new JTextField();
    private JLabel valueUnitTitle = new JLabel("");
    private JButton applyButton = new JButton(DPResource.get("AbstractDoubleValueSettingPanel.Apply"));

    protected void initialize() {
        this.initializeComponent();
        this.hook();
    }

    protected void initializeComponent() {
        this.applyButton.setMargin(new Insets(0, 5, 0, 5));
        this.valueTextfield.setColumns(7);
        this.add(this.manualLabel);
        this.add(this.valueTextfield);
        this.add(this.valueUnitTitle);
        this.add(this.applyButton);
        this.update();
    }

    private void hook() {
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AbstractDoubleValueSettingPanel.this.apply();
            }
        });
    }

    protected void update() {
        this.setUnit(this.getUnit());
        this.valueTextfield.setText(this.formatValue(this.getValue()));
    }

    public void apply() {
        try {
            this.setValue(Double.parseDouble(this.valueTextfield.getText()));
            this.update();
            this.applied();
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void setUnit(String unit) {
        this.valueUnitTitle.setText(unit);
    }

    protected String formatValue(double value) {
        try {
            return FORMATTER.valueToString(new Double(value));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            components[i].setEnabled(enabled);
            ++i;
        }
    }

    protected abstract void applied();

    protected abstract String getUnit();

    protected abstract double getValue();

    protected abstract void setValue(double var1);
}

