/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.dialogs;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.graph.viewer.dialogs.AbstractDoubleValueSettingPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class ScaleSettingPanel
extends JPanel
implements ItemListener {
    private GGraphContainer container;
    private GAxis axis;
    private JCheckBox checkbox = new JCheckBox();
    private ManualSettingPanel manualSettingPanel = new ManualSettingPanel();

    public ScaleSettingPanel(GGraphContainer container, GAxis axis) {
        this.container = container;
        this.axis = axis;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new VerticalFlowLayout());
        this.manualSettingPanel.initialize();
        this.initializeData();
        this.checkbox.setText(DPResource.get("ScaleSettingPanel.Auto"));
        this.add(this.checkbox);
        this.add(this.manualSettingPanel);
        this.hook();
    }

    public void initializeData() {
        this.checkbox.setSelected(this.axis.getScale().isAuto());
        this.manualSettingPanel.setEnabled(!this.axis.getScale().isAuto());
    }

    private void hook() {
        this.checkbox.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        this.update();
    }

    public void update() {
        this.axis.getScale().setAuto(this.checkbox.isSelected());
        this.manualSettingPanel.setEnabled(!this.checkbox.isSelected());
    }

    public void apply() {
        this.manualSettingPanel.apply();
    }

    class ManualSettingPanel
    extends AbstractDoubleValueSettingPanel {
        ManualSettingPanel() {
        }

        protected String getUnit() {
            return DPResource.get("ScaleSettingPanel.Percent");
        }

        protected double getValue() {
            return ScaleSettingPanel.this.axis.getScale().getValue() * 100.0;
        }

        protected void setValue(double value) {
            ScaleSettingPanel.this.axis.getScale().setValue(value / 100.0);
        }

        protected void applied() {
            ScaleSettingPanel.this.container.update();
        }
    }
}

